/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Either;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKeys;
import com.atlassian.jira.plugin.webfragment.conditions.cache.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Supplier;

@PublicApi
public class UserIsAdminCondition
extends AbstractWebCondition {
    private final Either<PermissionManager, GlobalPermissionManager> permissionManager;

    @Internal
    public UserIsAdminCondition(GlobalPermissionManager permissionManager) {
        this.permissionManager = Either.right((Object)permissionManager);
    }

    @Deprecated
    protected UserIsAdminCondition(PermissionManager permissionManager) {
        this.permissionManager = Either.left((Object)permissionManager);
    }

    @Override
    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return RequestCachingConditionHelper.cacheConditionResultInRequest(ConditionCacheKeys.permission(GlobalPermissionKey.ADMINISTER, user, new Object[0]), (Supplier<Boolean>)((Supplier)() -> (Boolean)this.permissionManager.fold(permissionManager -> permissionManager.hasPermission(0, user), permissionManager -> permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user))));
    }
}

