/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.builder.ToStringBuilder;

@PublicApi
public class NotificationRecipient {
    public static final String MIMETYPE_HTML = "html";
    public static final String MIMETYPE_HTML_DISPLAY = "HTML";
    public static final String MIMETYPE_TEXT = "text";
    public static final String MIMETYPE_TEXT_DISPLAY = "Text";
    private final ApplicationUser user;
    private final String email;
    private final String format;

    @VisibleForTesting
    String getFormatPreference(ApplicationUser user) {
        return ComponentAccessor.getUserPreferencesManager().getExtendedPreferences(user).getString("user.notifications.mimetype");
    }

    public NotificationRecipient(@Nonnull ApplicationUser user) {
        this.user = Assertions.notNull("It is not valid to build a notification recipient out of 'null' user", user);
        this.email = user.getEmailAddress();
        this.format = MIMETYPE_HTML.equals(this.getFormatPreference(user)) ? MIMETYPE_HTML : MIMETYPE_TEXT;
    }

    public NotificationRecipient(String pEmail) {
        this.user = null;
        this.email = pEmail;
        this.format = MIMETYPE_HTML;
    }

    public String getEmail() {
        return this.email;
    }

    public ApplicationUser getUserRecipient() {
        return this.user;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean isHtml() {
        return MIMETYPE_HTML.equals(this.format);
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isInGroup(String groupName) {
        return this.user != null && ComponentAccessor.getGroupManager().isUserInGroup(this.user, groupName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationRecipient)) {
            return false;
        }
        NotificationRecipient other = (NotificationRecipient)o;
        return Objects.equal((Object)this.email, (Object)other.email) && Objects.equal((Object)this.user, (Object)other.user);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.user, this.email});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("user", (Object)this.user).append("email", (Object)this.email).append("format", (Object)this.format).toString();
    }
}

