/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationReason;
import java.util.HashMap;
import java.util.Map;

@PublicApi
public class NotificationFilterContext {
    private final NotificationReason reason;
    private final Issue issue;
    private final Map<String, Object> state;

    public NotificationFilterContext() {
        this(null, null);
    }

    NotificationFilterContext(NotificationReason reason) {
        this(reason, null);
    }

    NotificationFilterContext(NotificationReason reason, Issue issue) {
        this.reason = reason;
        this.issue = issue;
        this.state = new HashMap<String, Object>();
    }

    NotificationFilterContext(NotificationFilterContext copy) {
        this.reason = copy.reason;
        this.issue = copy.issue;
        this.state = copy.state;
    }

    public NotificationReason getReason() {
        return this.reason;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public Object get(String stateKey) {
        return this.state.get(stateKey);
    }

    public Object put(String stateKey, Object stateValue) {
        return this.state.put(stateKey, stateValue);
    }
}

