/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.OrderByRequest;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;

@PublicApi
public class OrderByRequests {
    public static <T, F extends ExtractableField<T>> Ordering<T> toOrdering(final OrderByRequest<F> orderByRequest) {
        Ordering ordering = Ordering.natural().nullsLast().onResultOf(new Function<T, Comparable>(){

            public Comparable apply(T input) {
                return ((ExtractableField)orderByRequest.getField()).getValue(input);
            }
        });
        if (orderByRequest.getOrder() == OrderByRequest.Order.DESC) {
            ordering = ordering.reverse();
        }
        return ordering;
    }

    public static interface ExtractableField<T> {
        public Comparable getValue(T var1);
    }
}

