/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;

@ExperimentalApi
public class ErrorCollections {
    public static ErrorCollection empty() {
        return new SimpleErrorCollection();
    }

    public static ErrorCollection create(String errorMessage, ErrorCollection.Reason reason) {
        ErrorCollection result = ErrorCollections.empty();
        result.addErrorMessage(errorMessage, reason);
        return result;
    }

    public static ErrorCollection create(String field, String message, ErrorCollection.Reason reason) {
        ErrorCollection result = ErrorCollections.empty();
        result.addError(field, message, reason);
        return result;
    }

    public static ErrorCollection validationError(String field, String message) {
        return ErrorCollections.create(field, message, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    public static ErrorCollection copyOf(ErrorCollection errorCollection) {
        ErrorCollection result = ErrorCollections.empty();
        result.addErrorCollection(errorCollection);
        return result;
    }

    public static ErrorCollection join(ErrorCollection ... errorCollections) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        for (ErrorCollection collection : errorCollections) {
            errorCollection.addErrorCollection(collection);
        }
        return errorCollection;
    }
}

