/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyConditionHelper;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.plugin.webfragment.JiraWebContext;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@PublicApi
public class EntityPropertyEqualToCondition
extends AbstractWebCondition {
    private static final Logger log = Logger.getLogger((String)EntityPropertyEqualToCondition.class.getName());
    private static final JsonParser jsonParser = new JsonParser();
    private final PluginAccessor pluginAccessor;
    private ConditionParameters conditionParameters;

    public EntityPropertyEqualToCondition(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
        super.init(params);
        String entity = this.getNonNullValueFromParameter(params, "entity");
        String propertyKey = this.getNonNullValueFromParameter(params, "propertyKey");
        String expectedValue = this.getNonNullValueFromParameter(params, "value");
        String objectName = StringUtils.defaultString((String)params.get("objectName"));
        this.validateObjectNameHasCorrectSyntax(objectName);
        JsonElement jsonExpectedValue = EntityPropertyEqualToCondition.validateValueIsJson(expectedValue);
        this.conditionParameters = new ConditionParameters(entity, propertyKey, jsonExpectedValue, objectName);
    }

    private String getNonNullValueFromParameter(Map<String, String> params, String parameter) {
        String value = params.get(parameter);
        if (value == null) {
            throw new PluginParseException(String.format("No '%s' parameter specified for condition: %s", parameter, this.getClass().getName()));
        }
        return value;
    }

    private static JsonElement validateValueIsJson(String expectedValue) {
        JsonElement jsonExpectedValue;
        try {
            jsonExpectedValue = jsonParser.parse(expectedValue);
        }
        catch (JsonSyntaxException e) {
            throw new PluginParseException("Could not parse the value provided", (Throwable)e);
        }
        return jsonExpectedValue;
    }

    private void validateObjectNameHasCorrectSyntax(String objectName) {
        Optional<String> potentialError;
        if (StringUtils.isNotBlank((CharSequence)objectName) && (potentialError = EntityPropertyEqualToCondition.validateObjectName(objectName)).isPresent()) {
            throw new PluginParseException("Failed to read the objectName property: " + potentialError.get() + " (" + objectName + ")");
        }
    }

    static Optional<String> validateObjectName(String objectName) {
        if (objectName.contains("..")) {
            return Optional.of("Two '.' characters in a row is not valid in an objectName");
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> context) {
        Map<String, EntityPropertyConditionHelper> entityConditions = this.getEntityConditions();
        if (entityConditions.containsKey(this.conditionParameters.getEntity())) {
            JiraWebContext jiraWebContext;
            EntityPropertyConditionHelper condition = entityConditions.get(this.conditionParameters.getEntity());
            Optional<Long> entityId = condition.getEntityId(jiraWebContext = JiraWebContext.from(context));
            if (!entityId.isPresent()) {
                return false;
            }
            EntityPropertyService.PropertyResult propertyResult = condition.getProperty(jiraWebContext.getUser().orElse(null), entityId.get(), this.conditionParameters.getPropertyKey());
            if (!propertyResult.isValid()) {
                return false;
            }
            Option<EntityProperty> entityProperty = propertyResult.getEntityProperty();
            return (Boolean)entityProperty.fold(Suppliers.alwaysFalse(), ep -> {
                boolean stringComparisonEqual;
                JsonElement expectedValue;
                JsonElement actualValue = jsonParser.parse(ep.getValue());
                if (StringUtils.isNotBlank((CharSequence)this.conditionParameters.getObjectName())) {
                    Option<JsonElement> potentialValue = EntityPropertyEqualToCondition.getValueForPath(actualValue, this.conditionParameters.getObjectName());
                    if (potentialValue.isEmpty()) {
                        return false;
                    }
                    actualValue = (JsonElement)potentialValue.get();
                }
                if (actualValue.equals(expectedValue = this.conditionParameters.getExpectedValue())) {
                    return true;
                }
                if (StringUtils.isNotBlank((CharSequence)this.conditionParameters.getObjectName())) {
                    return false;
                }
                if (!expectedValue.isJsonPrimitive() || !actualValue.isJsonPrimitive()) {
                    return false;
                }
                JsonPrimitive actualValuePrimitive = actualValue.getAsJsonPrimitive();
                boolean bl = stringComparisonEqual = actualValuePrimitive.isString() && expectedValue.getAsString().equals(actualValuePrimitive.getAsString());
                if (stringComparisonEqual) {
                    String location = jiraWebContext.getLocation().orElse("NO_LOCATION_AVAILABLE");
                    log.warn((Object)("Deprecation Warning: EntityPropertyEqualToCondition was not equivalent by JSON comparison but was by String comparison. Please ensure that the entity property values and the condition 'value' are of the same json type. Type coercion has made the actual value: '" + ep.getValue() + "' be equivalent to the expected value" + "'" + this.conditionParameters.getExpectedValue() + "'. Please update the expected 'value' in the entity property condition" + "to match the actual value. This web fragment has the location: " + location));
                }
                return stringComparisonEqual;
            });
        }
        log.warn((Object)("Entity property condition is registered for invalid entity. Supported entities are " + entityConditions.keySet()));
        return false;
    }

    @Override
    public boolean shouldDisplay(ApplicationUser applicationUser, JiraHelper jiraHelper) {
        HashMap context = Maps.newHashMap();
        context.putAll(jiraHelper.getContextParams());
        context.put("user", applicationUser);
        return this.shouldDisplay(context);
    }

    @VisibleForTesting
    static Option<JsonElement> getValueForPath(JsonElement jsonEntityProperty, String path) {
        Preconditions.checkNotNull((Object)path, (Object)"The path passed into this method may not be null");
        String[] split = StringUtils.split((String)path, (char)'.');
        JsonElement value = jsonEntityProperty;
        for (String currentKey : split) {
            if (value == null || !value.isJsonObject()) {
                return Option.none();
            }
            value = value.getAsJsonObject().get(currentKey);
        }
        return Option.option((Object)value);
    }

    private Map<String, EntityPropertyConditionHelper> getEntityConditions() {
        return this.pluginAccessor.getEnabledModulesByClass(EntityPropertyConditionHelper.class).stream().collect(Collectors.toMap(EntityPropertyConditionHelper::getEntityName, Function.identity()));
    }

    private static final class ConditionParameters {
        private final String entity;
        private final String propertyKey;
        private final JsonElement expectedValue;
        private final String objectName;

        private ConditionParameters(String entity, String propertyKey, JsonElement expectedValue, String objectName) {
            this.entity = entity;
            this.propertyKey = propertyKey;
            this.expectedValue = expectedValue;
            this.objectName = objectName;
        }

        public String getEntity() {
            return this.entity;
        }

        public JsonElement getExpectedValue() {
            return this.expectedValue;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public String getObjectName() {
            return this.objectName;
        }
    }
}

