/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ListOrderedMessageSetImpl;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class ValuesExistValidator {
    private final JqlOperandResolver operandResolver;
    private final I18nHelper.BeanFactory beanFactory;
    private final MessageSet.Level level;

    ValuesExistValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this(operandResolver, beanFactory, MessageSet.Level.ERROR);
    }

    ValuesExistValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory, MessageSet.Level level) {
        this.beanFactory = Assertions.notNull("beanFactory", beanFactory);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.level = level;
    }

    MessageSet validate(TerminalClause terminalClause, QueryCreationContext queryCreationContext) {
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> rawOperandValues = this.operandResolver.getValues(queryCreationContext, operand, terminalClause);
        return this.validate(queryCreationContext.getApplicationUser(), terminalClause, rawOperandValues);
    }

    MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> rawOperandValues = this.operandResolver.getValues(searcher, operand, terminalClause);
        return this.validate(searcher, terminalClause, rawOperandValues);
    }

    private MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause, List<QueryLiteral> rawOperandValues) {
        Operand operand = terminalClause.getOperand();
        String fieldName = terminalClause.getName();
        ListOrderedMessageSetImpl messages = new ListOrderedMessageSetImpl();
        if (this.operandResolver.isValidOperand(operand)) {
            Collection<String> existingStrings = this.stringValuesExist(searcher, rawOperandValues.stream().map(QueryLiteral::getStringValue).filter(Objects::nonNull).collect(Collectors.toList()));
            Collection<Long> existingLongs = this.longValuesExist(searcher, rawOperandValues.stream().map(QueryLiteral::getLongValue).filter(Objects::nonNull).collect(Collectors.toList()));
            for (QueryLiteral rawValue : rawOperandValues) {
                if (rawValue.getStringValue() != null) {
                    if (existingStrings.contains(rawValue.getStringValue())) continue;
                    if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                        messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                        continue;
                    }
                    messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name", fieldName, rawValue.getStringValue()));
                    continue;
                }
                if (rawValue.getLongValue() == null || existingLongs.contains(rawValue.getLongValue())) continue;
                if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                    messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                    continue;
                }
                messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.id", fieldName, rawValue.getLongValue().toString()));
            }
        }
        return messages;
    }

    abstract boolean stringValueExists(ApplicationUser var1, String var2);

    abstract boolean longValueExist(ApplicationUser var1, Long var2);

    protected Collection<String> stringValuesExist(ApplicationUser searcher, List<String> values) {
        return values.stream().filter(value -> this.stringValueExists(searcher, (String)value)).collect(Collectors.toList());
    }

    protected Collection<Long> longValuesExist(ApplicationUser searcher, List<Long> values) {
        return values.stream().filter(value -> this.longValueExist(searcher, (Long)value)).collect(Collectors.toList());
    }

    I18nHelper getI18n(ApplicationUser user) {
        return this.beanFactory.getInstance(user);
    }
}

