/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@PublicApi
public class VersionResolver
implements NameResolver<Version> {
    private final VersionManager versionManager;

    public VersionResolver(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public List<String> getIdsFromName(String name) {
        return ((Collection)this.getIdsFromNames(Collections.singletonList(name)).getOrDefault(name, Collections.emptyList())).stream().collect(Collectors.toList());
    }

    @Override
    public boolean nameExists(String name) {
        Assertions.notNull("name", name);
        Collection<Version> versions = this.versionManager.getVersionsByName(name);
        return !versions.isEmpty();
    }

    @Override
    public boolean idExists(Long id) {
        Assertions.notNull("id", id);
        return this.versionManager.getVersion(id) != null;
    }

    @Override
    public Map<String, Collection<String>> getIdsFromNames(Collection<String> names) {
        return this.versionManager.getVersionsForNames(names).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).stream().map(ver -> ver.getId().toString()).collect(Collectors.toList())));
    }

    @Override
    public Collection<Long> getExistingIds(Collection<Long> ids) {
        return this.versionManager.getVersions(new LinkedList<Long>(ids)).stream().map(Version::getId).collect(Collectors.toList());
    }

    @Override
    public Version get(Long id) {
        return this.versionManager.getVersion(id);
    }

    public Map<String, Collection<Version>> get(Collection<String> names) {
        return this.versionManager.getVersionsForNames(names);
    }

    public Map<Long, Version> get(List<Long> ids) {
        return this.versionManager.getVersions(ids).stream().collect(Collectors.toMap(Version::getId, v -> v));
    }

    @Override
    public Collection<Version> getAll() {
        return this.versionManager.getAllVersions();
    }
}

