/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@PublicApi
public class VersionIndexInfoResolver
implements IndexInfoResolver<Version> {
    private final NameResolver<Version> versionResolver;

    public VersionIndexInfoResolver(NameResolver<Version> versionResolver) {
        this.versionResolver = versionResolver;
    }

    @Override
    public List<String> getIndexedValues(String rawValue) {
        Long versionId;
        Assertions.notNull("rawValue", rawValue);
        List<String> versions = this.versionResolver.getIdsFromName(rawValue);
        if (versions.isEmpty() && (versionId = Longs.tryParse((String)rawValue)) != null && this.versionResolver.idExists(versionId)) {
            versions = Collections.singletonList(rawValue);
        }
        return versions;
    }

    @Override
    public List<String> getIndexedValues(Long rawValue) {
        Assertions.notNull("rawValue", rawValue);
        if (this.versionResolver.idExists(rawValue)) {
            return ImmutableList.of((Object)rawValue.toString());
        }
        return this.versionResolver.getIdsFromName(rawValue.toString());
    }

    @Override
    public String getIndexedValue(Version version) {
        return Assertions.notNull("version", version).getId().toString();
    }

    @Override
    public Map<Long, Collection<String>> getIndexedLongValues(final Collection<Long> rawValues) {
        HashMap result = Maps.newHashMap();
        Collection<Long> existingAsIds = this.versionResolver.getExistingIds(rawValues);
        LazyReference<Map<String, Collection<String>>> indexedValuesByName = new LazyReference<Map<String, Collection<String>>>(){

            protected Map<String, Collection<String>> create() throws Exception {
                return VersionIndexInfoResolver.this.versionResolver.getIdsFromNames(rawValues.stream().map(rawValue -> rawValue.toString()).collect(Collectors.toList()));
            }
        };
        for (Long val : rawValues) {
            if (existingAsIds.contains(val)) {
                result.put(val, Collections.singletonList(val.toString()));
                continue;
            }
            result.put(val, ((Map)indexedValuesByName.get()).getOrDefault(val.toString(), Collections.emptyList()));
        }
        return result;
    }

    @Override
    public Map<String, Collection<String>> getIndexedStringValues(final Collection<String> rawValues) {
        HashMap result = Maps.newHashMap();
        Map<String, Collection<String>> indexedValuesByName = this.versionResolver.getIdsFromNames(rawValues);
        LazyReference<Collection<Long>> existingAsIds = new LazyReference<Collection<Long>>(){

            protected Collection<Long> create() throws Exception {
                return VersionIndexInfoResolver.this.versionResolver.getExistingIds(rawValues.stream().map(Longs::tryParse).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        };
        for (String val : rawValues) {
            Long valueAsLong;
            Collection<String> ids = indexedValuesByName.getOrDefault(val, Lists.newArrayList());
            if (ids.isEmpty() && (valueAsLong = Longs.tryParse((String)val)) != null && ((Collection)existingAsIds.get()).contains(valueAsLong)) {
                ids.add(val);
            }
            result.put(val, ids);
        }
        return result;
    }
}

