/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public abstract class AbstractOperatorQueryFactory<T> {
    private final IndexInfoResolver indexInfoResolver;

    protected AbstractOperatorQueryFactory(IndexInfoResolver indexInfoResolver) {
        this.indexInfoResolver = indexInfoResolver;
    }

    protected TermQuery getTermQuery(String fieldName, String indexValue) {
        return new TermQuery(new Term(fieldName, indexValue));
    }

    protected QueryFactoryResult checkQueryForEmpty(BooleanQuery query) {
        if (query.clauses().isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        return new QueryFactoryResult((Query)query);
    }

    List<String> getIndexValues(List<QueryLiteral> rawValues) {
        if (rawValues == null || rawValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList indexValues = Lists.newArrayListWithCapacity((int)rawValues.size());
        Map<String, Collection<String>> stringIndexes = this.indexInfoResolver.getIndexedStringValues(rawValues.stream().filter(Objects::nonNull).map(QueryLiteral::getStringValue).filter(Objects::nonNull).collect(Collectors.toList()));
        Map<Long, Collection<String>> longIndexes = this.indexInfoResolver.getIndexedLongValues(rawValues.stream().filter(Objects::nonNull).map(QueryLiteral::getLongValue).filter(Objects::nonNull).collect(Collectors.toList()));
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue == null) continue;
            if (rawValue.getStringValue() != null) {
                indexValues.addAll(stringIndexes.getOrDefault(rawValue.getStringValue(), Collections.emptyList()));
                continue;
            }
            if (rawValue.getLongValue() != null) {
                indexValues.addAll(longIndexes.getOrDefault(rawValue.getLongValue(), Collections.emptyList()));
                continue;
            }
            indexValues.add(null);
        }
        return indexValues;
    }
}

