/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.util.JqlVersionPredicate;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class VersionClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<Version>
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final VersionResolver versionResolver;

    public VersionClauseContextFactory(JqlOperandResolver jqlOperandResolver, VersionResolver versionResolver, PermissionManager permissionManager) {
        super(new VersionIndexInfoResolver(versionResolver), jqlOperandResolver, permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
    }

    private Tuple<Map<Long, Version>, Boolean> getSpecifiedVersion(final Collection<QueryLiteral> literals) {
        if (literals == null) {
            return new Tuple(Collections.emptyMap(), (Object)false);
        }
        HashMap specifiedVersions = Maps.newHashMapWithExpectedSize((int)literals.size());
        boolean containsEmpty = false;
        Map<Long, Version> versionsById = this.versionResolver.get(literals.stream().map(QueryLiteral::getLongValue).filter(Objects::nonNull).collect(Collectors.toList()));
        LazyReference<Map<String, Collection<Version>>> longVersionsByName = new LazyReference<Map<String, Collection<Version>>>(){

            protected Map<String, Collection<Version>> create() throws Exception {
                return VersionClauseContextFactory.this.versionResolver.get(literals.stream().map(QueryLiteral::getLongValue).filter(Objects::nonNull).map(id -> id.toString()).collect(Collectors.toList()));
            }
        };
        Map<String, Collection<Version>> versionsByName = this.versionResolver.get(literals.stream().map(QueryLiteral::getStringValue).filter(Objects::nonNull).collect(Collectors.toList()));
        LazyReference<Map<Long, Version>> stringVersionsById = new LazyReference<Map<Long, Version>>(){

            protected Map<Long, Version> create() throws Exception {
                return VersionClauseContextFactory.this.versionResolver.get(literals.stream().map(ql -> Longs.tryParse((String)ql.getStringValue())).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        };
        for (QueryLiteral literal : literals) {
            if (literal.isEmpty()) {
                containsEmpty = true;
                continue;
            }
            if (literal.getLongValue() != null) {
                Version v = versionsById.get(literal.getLongValue());
                if (v == null) {
                    ((Collection)((Map)longVersionsByName.get()).getOrDefault(literal.getLongValue().toString(), Collections.emptyList())).forEach(version -> specifiedVersions.put(version.getId(), version));
                    continue;
                }
                specifiedVersions.put(v.getId(), v);
                continue;
            }
            if (literal.getStringValue() == null) continue;
            Collection versions = versionsByName.getOrDefault(literal.getStringValue(), Collections.emptyList());
            if (versions.isEmpty()) {
                Version v;
                Long versionId = Longs.tryParse((String)literal.getStringValue());
                if (versionId != null || (v = (Version)((Map)stringVersionsById.get()).get(versionId)) == null) continue;
                specifiedVersions.put(v.getId(), v);
                continue;
            }
            versions.forEach(version -> specifiedVersions.put(version.getId(), version));
        }
        return new Tuple((Object)specifiedVersions, (Object)containsEmpty);
    }

    @Override
    ClauseContext getContextFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        Tuple<Map<Long, Version>, Boolean> specifiedVersionsTuple = this.getSpecifiedVersion(literals);
        Map specifiedVersions = (Map)specifiedVersionsTuple.getFirst();
        boolean containsEmpty = (Boolean)specifiedVersionsTuple.getLast();
        if (!specifiedVersions.isEmpty()) {
            Set<Object> contexts;
            if (this.isRelationalOperator(operator)) {
                HashSet<Long> checkedProjects = new HashSet<Long>();
                contexts = new HashSet();
                HashMap<Long, JqlVersionPredicate> temporaryPredicates = new HashMap<Long, JqlVersionPredicate>(specifiedVersions.size());
                for (Version version2 : this.versionResolver.getAll()) {
                    if (checkedProjects.contains(version2.getProjectId())) continue;
                    for (Version specifiedVersion : specifiedVersions.values()) {
                        temporaryPredicates.computeIfAbsent(specifiedVersion.getId(), id -> new JqlVersionPredicate(operator, specifiedVersion));
                        if (!((JqlVersionPredicate)temporaryPredicates.get(specifiedVersion.getId())).evaluate(version2)) continue;
                        checkedProjects.add(version2.getProjectId());
                        contexts.addAll(this.getContextsForProject(searcher, version2.getProject()));
                    }
                }
            } else {
                contexts = this.isNegationOperator(operator) ? this.versionResolver.getAll().stream().filter(version -> specifiedVersions.get(version.getId()) == null).map(Version::getProject).distinct().map(project -> this.getContextsForProject(searcher, (Project)project)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet()) : specifiedVersions.values().stream().map(Version::getProject).distinct().map(project -> this.getContextsForProject(searcher, (Project)project)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            }
            if (containsEmpty) {
                contexts.add(ProjectIssueTypeContextImpl.createGlobalContext());
            }
            return new ClauseContextImpl(contexts);
        }
        return ClauseContextImpl.createGlobalClauseContext();
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator) || OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

