/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import java.util.Optional;

@PublicSpi
public abstract class AbstractProjectPermissionCondition
extends AbstractWebCondition {
    private ProjectPermissionKey permissionKey;

    @Override
    public final void init(Map<String, String> params) throws PluginParseException {
        String providedKey = params.get("permission");
        if (providedKey == null) {
            throw new PluginParseException("permission parameter is required");
        }
        this.permissionKey = this.getPermissionKey(providedKey);
        super.init(params);
    }

    @Override
    public final boolean shouldDisplay(Map<String, Object> context) {
        return super.shouldDisplay(context);
    }

    @Override
    public final boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return this.shouldDisplay(user, jiraHelper, this.permissionKey);
    }

    protected abstract boolean shouldDisplay(ApplicationUser var1, JiraHelper var2, ProjectPermissionKey var3);

    private ProjectPermissionKey getPermissionKey(String providedKey) {
        return this.legacyPermissionKey(providedKey).orElse(new ProjectPermissionKey(providedKey));
    }

    private Optional<ProjectPermissionKey> legacyPermissionKey(String providedKey) {
        return Optional.ofNullable(ProjectPermissions.systemProjectPermissionKeyByShortName(providedKey));
    }
}

