/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.icon.IconType;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public interface Avatar {
    public static final List<String> demotedSystemProjectAvatars = ImmutableList.of((Object)"codegeist.png", (Object)"jm_black.png", (Object)"jm_brown.png", (Object)"jm_orange.png", (Object)"jm_red.png", (Object)"jm_white.png", (Object)"jm_yellow.png", (Object)"monster.png");
    public static final List<String> demotedSystemUserAvatars = ImmutableList.of((Object)"Avatar-1.png", (Object)"Avatar-2.png", (Object)"Avatar-3.png", (Object)"Avatar-4.png", (Object)"Avatar-5.png", (Object)"Avatar-6.png", (Object)"Avatar-7.png", (Object)"Avatar-8.png", (Object)"Avatar-9.png", (Object)"Avatar-10.png", (Object)"Avatar-11.png", (Object)"Avatar-12.png", (Object[])new String[]{"Avatar-13.png", "Avatar-14.png", "Avatar-15.png", "Avatar-16.png", "Avatar-17.png", "Avatar-18.png", "Avatar-19.png", "Avatar-20.png", "Avatar-21.png", "Avatar-22.png", "Avatar-addnew.png", "Avatar-default.png", "Avatar-unknown.png"});

    @Nonnull
    public Type getAvatarType();

    @Nonnull
    public IconType getIconType();

    @Nonnull
    public String getFileName();

    @Nonnull
    public String getContentType();

    public Long getId();

    public String getOwner();

    public boolean isSystemAvatar();

    public static enum Size {
        NORMAL("small", 24),
        SMALL("xsmall", 16),
        MEDIUM("medium", 32),
        LARGE("large", 48, true),
        XLARGE("xlarge", 64),
        NORMAL_3X("small@3x", 72),
        XXLARGE("xxlarge", 96),
        XXXLARGE("xxxlarge", 128),
        LARGE_3X("large@3x", 144),
        RETINA_XXLARGE("xxlarge@2x", 192),
        RETINA_XXXLARGE("xxxlarge@2x", 256),
        RETINA_XXLARGE_3X("xxlarge@3x", 288),
        RETINA_XXXLARGE_3X("xxxlarge@3x", 384);

        public static final Predicate<Size> LOW_RES;
        final String param;
        final Integer pixels;
        final boolean isDefault;
        private static final Size largest;
        private static final Size defaultSize;
        private static final List<Size> orderedSizes;
        private static final SortedMap<String, Size> paramToSize;

        private boolean isMultiplied() {
            return this.param.contains("@");
        }

        private static SortedMap<String, Size> createParamToSizeMap() {
            ImmutableMap exactMapping = Maps.uniqueIndex(Arrays.asList(Size.values()), Size::getParam);
            ImmutableList multipliers = ImmutableList.of((Object)Pair.pair((Object)"@2x", (Object)2), (Object)Pair.pair((Object)"@3x", (Object)3));
            Map<String, Size> multipliedParamsMapping = Arrays.asList(Size.values()).stream().filter(size -> !size.isMultiplied()).flatMap(arg_0 -> Size.lambda$createParamToSizeMap$3((List)multipliers, arg_0)).collect(Collectors.toMap(Pair::left, Pair::right));
            TreeMap result = Maps.newTreeMap();
            result.putAll(exactMapping);
            result.putAll(multipliedParamsMapping);
            return ImmutableSortedMap.copyOfSorted((SortedMap)result);
        }

        private Size(String param, int pixels, boolean isDefault) {
            this.param = param;
            this.isDefault = isDefault;
            this.pixels = pixels;
        }

        private Size(String param, int pixels) {
            this(param, pixels, false);
        }

        public static Size largest() {
            return largest;
        }

        public static Size defaultSize() {
            return defaultSize;
        }

        public static Size biggerThan(int pixelValue) {
            Size theSize = null;
            for (Size aSize : Size.inPixelOrder()) {
                if (aSize.pixels < pixelValue) continue;
                theSize = aSize;
                break;
            }
            return theSize;
        }

        public static Size smallerThan(int pixelValue) {
            Size theSize = null;
            for (Size aSize : Lists.reverse(Size.inPixelOrder())) {
                if (aSize.pixels > pixelValue) continue;
                theSize = aSize;
                break;
            }
            return theSize;
        }

        static List<Size> inPixelOrder() {
            if (null != orderedSizes) {
                return orderedSizes;
            }
            List<Size> orderedSizes = Arrays.asList(Size.values());
            Collections.sort(orderedSizes, new Comparator<Size>(){

                @Override
                public int compare(Size o1, Size o2) {
                    if (o1.getPixels() == o2.getPixels()) {
                        return 0;
                    }
                    return o1.getPixels() < o2.getPixels() ? -1 : 1;
                }
            });
            return orderedSizes;
        }

        public int getPixels() {
            return this.pixels;
        }

        public String getParam() {
            return this.param;
        }

        public String toString() {
            return String.format("<Size [%s], %dx%dpx>", this.param, this.pixels, this.pixels);
        }

        public static Size getSizeFromParam(String param) {
            if (null == param || !paramToSize.containsKey(param)) {
                throw new NoSuchElementException(param);
            }
            return (Size)((Object)paramToSize.get(param));
        }

        public static Size fromString(String text) {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                int sizeInPixels = -1;
                try {
                    sizeInPixels = Integer.parseInt(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (String param : paramToSize.keySet()) {
                    Size size = (Size)((Object)paramToSize.get(param));
                    if ((sizeInPixels <= 0 || sizeInPixels != size.getPixels()) && !StringUtils.startsWithIgnoreCase((CharSequence)size.name(), (CharSequence)text) && !StringUtils.startsWithIgnoreCase((CharSequence)param, (CharSequence)text)) continue;
                    return size;
                }
            }
            return Size.defaultSize();
        }

        public static Size approx(int size) {
            if (size >= largest.getPixels()) {
                return largest;
            }
            if (size <= orderedSizes.get(0).getPixels()) {
                return orderedSizes.get(0);
            }
            for (Size s : orderedSizes) {
                if (s.getPixels() < size) continue;
                return s;
            }
            return defaultSize;
        }

        private static /* synthetic */ Stream lambda$createParamToSizeMap$3(List multipliers, Size size) {
            return multipliers.stream().map(multiplier -> Pair.pair((Object)(size.getParam() + (String)multiplier.left()), (Object)(size.getPixels() * (Integer)multiplier.right()))).map(multiplied -> Pair.pair((Object)multiplied.left(), (Object)((Object)Size.approx((Integer)multiplied.right()))));
        }

        static {
            LOW_RES = new Predicate<Size>(){

                public boolean apply(Size input) {
                    return input.getPixels() <= 48;
                }
            };
            Size maxValue = SMALL;
            Size defaultValue = SMALL;
            for (Size imageSize : Size.values()) {
                if (imageSize.isDefault) {
                    defaultValue = imageSize;
                }
                if (imageSize.pixels <= maxValue.pixels) continue;
                maxValue = imageSize;
            }
            largest = maxValue;
            defaultSize = defaultValue;
            orderedSizes = Size.inPixelOrder();
            paramToSize = Size.createParamToSizeMap();
        }
    }

    @Deprecated
    public static enum Type {
        PROJECT("project", "jira.avatar.default.id"),
        USER("user", "jira.avatar.user.default.id"),
        ISSUETYPE("issuetype", "jira.avatar.issuetype.default.id"),
        OTHER("other", null);

        private String name;
        private String defaultIdKey;
        private static final Map<String, Type> typesByName;

        private static ImmutableMap<String, Type> createNameToTypeMap() {
            ImmutableMap.Builder typesByNameBuilder = ImmutableMap.builder();
            for (Type type : Type.values()) {
                typesByNameBuilder.put((Object)type.getName(), (Object)type);
            }
            return typesByNameBuilder.build();
        }

        private Type(String name, String defaultIdKey) {
            this.name = name;
            this.defaultIdKey = defaultIdKey;
        }

        public String getName() {
            return this.name;
        }

        public static Type getByName(String name) {
            return name == null ? null : typesByName.get(name);
        }

        public static Type getByIconType(IconType iconType) {
            if (iconType == null) {
                return null;
            }
            if (Type.supportsName(iconType.getKey())) {
                return Type.getByName(iconType.getKey());
            }
            return OTHER;
        }

        public static boolean supportsName(String name) {
            if (name == null) {
                return false;
            }
            return typesByName.get(name) != null;
        }

        public Long getDefaultId(ApplicationProperties applicationProperties) {
            if (this.defaultIdKey == null) {
                throw new UnsupportedOperationException("cannot retrieve default ID for custom avatar type");
            }
            String defaultAvatarId = applicationProperties.getString(this.defaultIdKey);
            return defaultAvatarId != null ? Long.valueOf(defaultAvatarId) : null;
        }

        static {
            typesByName = Type.createNameToTypeMap();
        }
    }
}

