/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum DatabaseVendor {
    POSTGRES("Postgres"),
    ORACLE("Oracle"),
    SQL_SERVER("SQL Server"){

        @Override
        public String getHumanReadableVersion(String version) {
            return 1.getSQLServerVersionIfExists(version);
        }
    }
    ,
    H2("H2"),
    MY_SQL("MySQL"),
    FAKE_DATABASE_FOR_TESTING("fakedatabase");

    final String humanReadableName;
    private static final Map<String, String> MSSQL_VERSION_ALIASES;

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    private DatabaseVendor(String humanReadableName) {
        this.humanReadableName = humanReadableName;
    }

    public static String getSQLServerVersionIfExists(String version) {
        return MSSQL_VERSION_ALIASES.entrySet().stream().filter(entry -> version.matches((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(version);
    }

    public String getHumanReadableVersion(String databaseVersion) {
        return databaseVersion;
    }

    static {
        MSSQL_VERSION_ALIASES = ImmutableMap.builder().put((Object)"14.*", (Object)"2017").put((Object)"13.*", (Object)"2016").put((Object)"12.*", (Object)"2014").put((Object)"11.*", (Object)"2012").put((Object)"10.5.+", (Object)"2008 R2").put((Object)"10.[0-4].*", (Object)"2008").put((Object)"9.*", (Object)"2005").put((Object)"8.*", (Object)"2000").build();
    }
}

