/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.EmptyOperand;
import javax.annotation.Nonnull;

public class AttachmentsClauseValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator = this.getSupportedOperatorsValidator();

    @Override
    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        Assertions.notNull("terminalClause", terminalClause);
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors() && !(terminalClause.getOperand() instanceof EmptyOperand)) {
            errors.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name", terminalClause.getName(), terminalClause.getOperand().getDisplayString()));
        }
        return errors;
    }

    private SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(SystemSearchConstants.forAttachments().getSupportedOperators());
    }

    I18nHelper getI18n(ApplicationUser user) {
        return ComponentAccessor.getComponent(I18nHelper.BeanFactory.class).getInstance(user);
    }
}

