/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import java.util.HashSet;
import java.util.List;

public class CustomFieldClauseContextFactory
implements ClauseContextFactory {
    private final CustomField customField;
    private final FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil;
    private final ContextSetUtil contextSetUtil;

    public CustomFieldClauseContextFactory(CustomField customField, FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil, ContextSetUtil contextSetUtil) {
        this.customField = customField;
        this.fieldConfigSchemeClauseContextUtil = fieldConfigSchemeClauseContextUtil;
        this.contextSetUtil = contextSetUtil;
    }

    @Override
    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        List<FieldConfigScheme> fieldConfigSchemes = this.customField.getConfigurationSchemes();
        HashSet<ClauseContext> ctxs = new HashSet<ClauseContext>();
        boolean globalContextSeen = false;
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            ClauseContext configContext = this.fieldConfigSchemeClauseContextUtil.getContextForConfigScheme(searcher, fieldConfigScheme);
            if (configContext.containsGlobalContext()) {
                globalContextSeen = true;
                break;
            }
            ctxs.add(configContext);
        }
        if (globalContextSeen || ctxs.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext returnContext = ctxs.size() == 1 ? (ClauseContext)ctxs.iterator().next() : this.contextSetUtil.union(ctxs);
        return returnContext.getContexts().isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : returnContext;
    }
}

