/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import java.util.HashMap;
import java.util.Map;

@PublicApi
public class TransitionOptions {
    private static final String SKIP_CONDITIONS_WORKFLOW_PARAMETER = "com.atlassian.jira.internal.workflow.skipConditions";
    private static final String SKIP_VALIDATORS_WORKFLOW_PARAMETER = "com.atlassian.jira.internal.workflow.skipValidators";
    private static final String AUTOMATIC_TRANSITION_WORKFLOW_PARAMETER = "com.atlassian.jira.internal.workflow.automaticTransition";
    private final boolean skipConditions;
    private final boolean skipValidators;
    private final boolean skipPermissions;
    private final boolean automaticTransition;

    @Internal
    private TransitionOptions(boolean skipConditions, boolean skipValidators, boolean skipPermissions, boolean automaticTransition) {
        this.skipConditions = skipConditions;
        this.skipValidators = skipValidators;
        this.skipPermissions = skipPermissions;
        this.automaticTransition = automaticTransition;
    }

    public static TransitionOptions defaults() {
        return new TransitionOptions(false, false, false, false);
    }

    public boolean skipConditions() {
        return this.skipConditions;
    }

    public boolean skipValidators() {
        return this.skipValidators;
    }

    public boolean skipPermissions() {
        return this.skipPermissions;
    }

    public boolean isAutomaticTransition() {
        return this.automaticTransition;
    }

    public Map<String, Object> getWorkflowParams() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.skipConditions) {
            result.put(SKIP_CONDITIONS_WORKFLOW_PARAMETER, this.skipConditions);
        }
        if (this.skipValidators) {
            result.put(SKIP_VALIDATORS_WORKFLOW_PARAMETER, this.skipValidators);
        }
        if (this.automaticTransition) {
            result.put(AUTOMATIC_TRANSITION_WORKFLOW_PARAMETER, this.automaticTransition);
        }
        return result;
    }

    public static TransitionOptions toTransitionOptions(Map<String, Object> workflowMap) {
        return new TransitionOptions(TransitionOptions.getBooleanValue(SKIP_CONDITIONS_WORKFLOW_PARAMETER, workflowMap), TransitionOptions.getBooleanValue(SKIP_VALIDATORS_WORKFLOW_PARAMETER, workflowMap), false, TransitionOptions.getBooleanValue(AUTOMATIC_TRANSITION_WORKFLOW_PARAMETER, workflowMap));
    }

    private static boolean getBooleanValue(String key, Map<String, Object> map) {
        if (map.containsKey(key)) {
            Boolean value = (Boolean)map.get(key);
            return value;
        }
        return false;
    }

    public static class Builder {
        private boolean skipConditions;
        private boolean skipValidators;
        private boolean skipPermissions;
        private boolean automaticTransition;

        public Builder skipConditions() {
            this.skipConditions = true;
            return this;
        }

        public Builder skipValidators() {
            this.skipValidators = true;
            return this;
        }

        public Builder skipPermissions() {
            this.skipPermissions = true;
            return this;
        }

        public Builder setAutomaticTransition() {
            this.automaticTransition = true;
            return this;
        }

        public TransitionOptions build() {
            return new TransitionOptions(this.skipConditions, this.skipValidators, this.skipPermissions, this.automaticTransition);
        }
    }
}

