/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class SharedEntitySearchEvent {
    private final SharedEntity.TypeDescriptor type;
    private final SharedEntitySearchParameters searchParameters;
    private final long elapsed;

    public SharedEntitySearchEvent(@Nonnull SharedEntity.TypeDescriptor type, @Nonnull SharedEntitySearchParameters searchParameters, long elapsed) {
        this.type = type;
        this.searchParameters = searchParameters;
        this.elapsed = elapsed;
    }

    @EventName
    public String calculateEventName() {
        return "jira.shared." + this.type.getName().toLowerCase() + ".search";
    }

    public boolean isByName() {
        return !StringUtils.isEmpty((String)this.searchParameters.getName());
    }

    public boolean isByDescription() {
        return !StringUtils.isEmpty((String)this.searchParameters.getDescription());
    }

    public boolean isFavourite() {
        return this.searchParameters.getFavourite() == null ? false : this.searchParameters.getFavourite();
    }

    public boolean isAscendingSort() {
        return this.searchParameters.isAscendingSort();
    }

    public boolean isByUser() {
        return !StringUtils.isEmpty((String)this.searchParameters.getUserName());
    }

    public long getElapsedMillis() {
        return this.elapsed;
    }
}

