package com.atlassian.jira.util;

import com.google.common.collect.ImmutableList;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * A simple implementation of the warning collection interface
 *
 * @since v7.0.0
 */
public class SimpleWarningCollection implements WarningCollection
{
    private List<String> warnings = new LinkedList<>();

    @Override
    public void addWarning(final String warningMessage)
    {
        warnings.add(warningMessage);
    }

    @Override
    public Collection<String> getWarnings()
    {
        return ImmutableList.copyOf(warnings);
    }

    @Override
    public boolean hasAnyWarnings()
    {
        return !warnings.isEmpty();
    }

    @Override
    public boolean equals(final Object o)
    {
        if (this == o) { return true; }
        if (o == null || getClass() != o.getClass()) { return false; }

        final SimpleWarningCollection that = (SimpleWarningCollection) o;

        return !(warnings != null ? !warnings.equals(that.warnings) : that.warnings != null);

    }

    @Override
    public int hashCode()
    {
        return warnings != null ? warnings.hashCode() : 0;
    }
}
