package com.atlassian.jira.util;

import java.util.Comparator;

import javax.annotation.Nullable;

import org.apache.commons.lang3.StringUtils;

import static com.atlassian.jira.util.dbc.Assertions.notNull;

/**
 * @since v5.2
 */
public interface Named
{
    String getName();

    public static final Comparator<Named> NAME_COMPARATOR = new Comparator<Named>() {
        @Override
        public int compare(Named named, Named named2) {
            return named.getName().compareTo(named2.getName());
        }
    };
}
