package com.atlassian.jira.project.type;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;

/**
 * Condition that returns true when the dark feature for project types for a given user is enabled.
 *
 * @since 7.0
 */
@Internal
public class ProjectTypesEnabledCondition extends AbstractWebCondition
{
    private final ProjectTypesDarkFeature darkFeature;

    public ProjectTypesEnabledCondition(final ProjectTypesDarkFeature darkFeature)
    {
        this.darkFeature = darkFeature;
    }

    @Override
    public boolean shouldDisplay(final ApplicationUser user, final JiraHelper jiraHelper)
    {
        return darkFeature.isEnabled();
    }
}
