package com.atlassian.jira.project.template;

import java.util.List;
import java.util.Optional;

import com.atlassian.annotations.PublicApi;

/**
 * Manager to access project templates.
 *
 * @since 7.0
 */
@PublicApi
public interface ProjectTemplateManager
{
    /**
     * Get the list of Project Template for a given user within a given context
     *
     * @return The list of available project templates
     */
    List<ProjectTemplate> getProjectTemplates();

    /**
     * Retrieves a project template by its key in the {@code atlassian-plugin.xml}.
     *
     * @param projectTemplateKey The key of the project template.
     * @return the requested project template
     */
    Optional<ProjectTemplate> getProjectTemplate(ProjectTemplateKey projectTemplateKey);

    /**
     * Gets a default template that can be used to create a project.
     *
     * @return The default template.
     */
    ProjectTemplate getDefaultTemplate();
}
