package com.atlassian.jira.plugin.webfragment.conditions;

import java.util.Map;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;

import static com.atlassian.jira.plugin.webfragment.conditions.AbstractPermissionCondition.getHasPermissionKey;
import static com.atlassian.jira.plugin.webfragment.conditions.RequestCachingConditionHelper.cacheConditionResultInRequest;

/**
 * Convenient abstraction to initialise conditions that require the {@link com.atlassian.jira.security.PermissionManager}.
 *
 * @since v6.4
 */
@PublicSpi
@ExperimentalApi
public abstract class AbstractFixedPermissionCondition extends AbstractWebCondition
{
    protected final PermissionManager permissionManager;
    protected final int permission;

    public AbstractFixedPermissionCondition(PermissionManager permissionManager, int permission)
    {
        this.permissionManager = permissionManager;
        this.permission = permission;
    }

    public void init(Map<String,String> params) throws PluginParseException
    {
        super.init(params);
    }

    public boolean shouldDisplay(final ApplicationUser user, JiraHelper jiraHelper)
    {
        return cacheConditionResultInRequest(getHasPermissionKey(permission, user),
                () -> permissionManager.hasPermission(permission, user));
    }

}
