package com.atlassian.jira.issue.customfields;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;

import javax.annotation.Nonnull;

/**
 * A custom field searcher will implement this interface if the custom field can be sorted.  If a custom field
 * wishes to sort itself, it can use the slower method {@link com.atlassian.jira.issue.customfields.SortableCustomField}.
 *
 * @see com.atlassian.jira.issue.customfields.SortableCustomField
 * @see com.atlassian.jira.issue.customfields.MultiSortableCustomFieldSearcher
 * @see NaturallyOrderedCustomFieldSearcher
 */
@PublicSpi
public interface SortableCustomFieldSearcher
{
    @Nonnull
    LuceneFieldSorter getSorter(CustomField customField);
}
