package com.atlassian.jira.entity;

import java.util.Comparator;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Entities implementing this interface are supposed to be uniquely identifiable by id.
 * @since v6.2
 */
@ExperimentalApi
public interface WithId
{
    /**
     * @return the unique id of the entity.
     */
    Long getId();

    public static final Comparator<WithId> ID_COMPARATOR = new Comparator<WithId>()
    {
        @Override
        public int compare(final WithId o1, final WithId o2)
        {
            final Long id1 = o1.getId();
            final Long id2 = o2.getId();

            if (id1 == null && id2 == null)
            {
                return 0;
            }
            else if (id1 == null)
            {
                // sort null ID to top
                return -1;
            }
            else if (id2 == null)
            {
                // sort null ID to top
                return 1;
            }
            else
            {
                return id1.compareTo(id2);
            }
        }
    };
}
