package com.atlassian.jira.bc;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.atlassian.jira.util.dbc.Assertions;

/**
 * Simple implementation of a validation result.
 *
 * Consider using {@link com.atlassian.jira.bc.ServiceOutcome}, which avoids to have to create a new class.
 * <p>
 * Included in the jira-api module not because it should be used by plugin developers, but because it is extended by
 * inner classes on many Services eg see {@link com.atlassian.jira.bc.issue.IssueService.TransitionValidationResult}
 *
 * @since v4.0
 */
@PublicApi
public class ServiceResultImpl implements ServiceResult
{
    private final ErrorCollection errorCollection;
    private final WarningCollection warningCollection;

    public ServiceResultImpl(ErrorCollection errorCollection)
    {
        this(errorCollection, new SimpleWarningCollection());
    }

    public ServiceResultImpl(ErrorCollection errorCollection, WarningCollection warningCollection)
    {
        Assertions.notNull("errorCollection", errorCollection);
        Assertions.notNull("errorCollection", warningCollection);
        this.errorCollection = errorCollection;
        this.warningCollection = warningCollection;
    }

    public boolean isValid()
    {
        return !errorCollection.hasAnyErrors();
    }

    public ErrorCollection getErrorCollection()
    {
        return errorCollection;
    }

    public WarningCollection getWarningCollection()
    {
        return warningCollection;
    }
}
