/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.util.JqlVersionPredicate;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class VersionClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<Version>
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final VersionResolver versionResolver;

    public VersionClauseContextFactory(JqlOperandResolver jqlOperandResolver, VersionResolver versionResolver, PermissionManager permissionManager) {
        super(new VersionIndexInfoResolver(versionResolver), jqlOperandResolver, permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
    }

    @Override
    ClauseContext getContextFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        final HashMap specifiedVersions = literals != null ? Maps.newHashMapWithExpectedSize((int)literals.size()) : Maps.newHashMap();
        boolean containsEmpty = false;
        if (literals != null) {
            for (QueryLiteral queryLiteral : literals) {
                if (queryLiteral.isEmpty()) {
                    containsEmpty = true;
                    continue;
                }
                List<Long> ids = this.getIds(queryLiteral);
                for (Long l : ids) {
                    specifiedVersions.put(l, this.versionResolver.get(l));
                }
            }
        }
        if (!specifiedVersions.isEmpty()) {
            Collection<Object> contextVersions;
            if (this.isRelationalOperator(operator)) {
                contextVersions = new ArrayList();
                for (Version specifiedVersion : specifiedVersions.values()) {
                    JqlVersionPredicate predicate = new JqlVersionPredicate(operator, specifiedVersion);
                    for (Version matchedVersion : CollectionUtil.filter(this.versionResolver.getAll(), predicate)) {
                        contextVersions.add(matchedVersion);
                    }
                }
            } else {
                contextVersions = this.isNegationOperator(operator) ? CollectionUtil.filter(this.versionResolver.getAll(), new Predicate<Version>(){

                    @Override
                    public boolean evaluate(@Nullable Version input) {
                        return !specifiedVersions.containsKey(input.getId());
                    }
                }) : specifiedVersions.values();
            }
            HashSet<ProjectIssueTypeContext> hashSet = new HashSet<ProjectIssueTypeContext>();
            HashSet<Long> checkedProjects = new HashSet<Long>();
            for (Version version : contextVersions) {
                if (!checkedProjects.add(version.getProjectId())) continue;
                hashSet.addAll(this.getContextsForProject(searcher, version.getProjectObject()));
            }
            if (containsEmpty) {
                hashSet.add(ProjectIssueTypeContextImpl.createGlobalContext());
            }
            return new ClauseContextImpl(hashSet);
        }
        return ClauseContextImpl.createGlobalClauseContext();
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator) || OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

