/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;

@PublicApi
public class Pages {
    public static <T> Page<T> toPage(Iterable<T> allValues, PageRequest pageRequest) {
        return Pages.toPage(allValues, pageRequest, val -> true, Function.identity());
    }

    public static <T, R> Page<R> toPage(Iterable<T> values, PageRequest pageRequest, Predicate<T> filter, Function<T, R> transform, int maxResults) {
        List filteredValues = StreamSupport.stream(values.spliterator(), false).filter(filter).collect(Collectors.toList());
        return (Page)filteredValues.stream().skip(pageRequest.getStart()).limit(Math.min(pageRequest.getLimit(), maxResults)).map(transform).collect(Pages.collector(pageRequest.getStart(), filteredValues.size()));
    }

    public static <T, R> Page<R> toPage(Iterable<T> values, PageRequest pageRequest, Predicate<T> filter, Function<T, R> transform) {
        return Pages.toPage(values, pageRequest, filter, transform, 0x100000);
    }

    public static <E> PageBuilder<E> createPage(List<E> values) {
        return new PageBuilder<E>(values);
    }

    public static <T> ListPageCollector<T> collector(long start, long total) {
        return new ListPageCollector(start, total);
    }

    public static class ListPageCollector<E>
    implements Collector<E, ArrayList<E>, Page<E>> {
        private final long start;
        private final long total;

        private ListPageCollector(long start, long total) {
            this.start = start;
            this.total = total;
        }

        @Override
        public Supplier<ArrayList<E>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<ArrayList<E>, E> accumulator() {
            return ArrayList::add;
        }

        @Override
        public BinaryOperator<ArrayList<E>> combiner() {
            return (left, right) -> {
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<ArrayList<E>, Page<E>> finisher() {
            return builder -> Pages.createPage(builder).startingAt(this.start).withCount(this.total);
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    @Immutable
    private static final class PageImpl<T>
    implements Page<T> {
        private final long start;
        private final long total;
        private final int size;
        private final List<T> values;

        public PageImpl(long start, long total, List<T> values) {
            this.start = start;
            this.size = values.size();
            this.total = total;
            this.values = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(values)));
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public long getTotal() {
            return this.total;
        }

        @Override
        public List<T> getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageImpl page = (PageImpl)o;
            if (this.size != page.size) {
                return false;
            }
            if (this.start != page.start) {
                return false;
            }
            if (this.total != page.total) {
                return false;
            }
            return !(this.values != null ? !this.values.equals(page.values) : page.values != null);
        }

        public int hashCode() {
            int result = (int)(this.start ^ this.start >>> 32);
            result = 31 * result + (int)(this.total ^ this.total >>> 32);
            result = 31 * result + this.size;
            result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PageImpl{start=" + this.start + ", total=" + this.total + ", size=" + this.size + ", values=" + this.values + '}';
        }
    }

    public static final class PageBuilder2<T> {
        private final List<T> values;
        private final Long startAt;

        public PageBuilder2(List<T> values, Long startAt) {
            this.values = values;
            this.startAt = startAt;
        }

        public Page<T> withCount(Long count) {
            return new PageImpl<T>(this.startAt, count, this.values);
        }
    }

    public static final class PageBuilder<T> {
        private final List<T> values;

        public PageBuilder(List<T> values) {
            this.values = values;
        }

        public PageBuilder2<T> startingAt(Long startAt) {
            return new PageBuilder2<T>(this.values, startAt);
        }
    }
}

