/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class UserJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String name;
    @JsonProperty
    private String key;
    @JsonProperty
    private String emailAddress;
    @JsonProperty
    private Map<String, String> avatarUrls;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private String timeZone;
    public static final UserJsonBean USER_DOC_EXAMPLE = new UserJsonBean();
    public static final UserJsonBean USER_SHORT_DOC_EXAMPLE = new UserJsonBean();

    public UserJsonBean() {
    }

    public UserJsonBean(String self, String name, String key, String emailAddress, Map<String, String> avatarUrls, String displayName, boolean active, String timeZone) {
        this.self = self;
        this.name = name;
        this.key = key;
        this.emailAddress = emailAddress;
        this.avatarUrls = avatarUrls;
        this.displayName = displayName;
        this.active = active;
        this.timeZone = timeZone;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Deprecated
    public void setEmailAddress(String emailAddress) {
        this.setEmailAddress(emailAddress, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public void setEmailAddress(String emailAddress, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        this.emailAddress = emailFormatter.formatEmail(emailAddress, loggedInUser);
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public void setAvatarUrls(Map<String, String> avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeans(Collection<ApplicationUser> users, JiraBaseUrls urls) {
        return UserJsonBean.shortBeans(users, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeans(Collection<ApplicationUser> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        return UserJsonBean.shortBeans(users, urls, loggedInUser, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeans(Collection<ApplicationUser> applicationUsers, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        if (applicationUsers == null) {
            return null;
        }
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection(applicationUsers, loggedInUser, urls, emailFormatter, timeZoneManager);
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection(users, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), urls, ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection(users, loggedInUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static Collection<UserJsonBean> shortBeanCollection(Collection<ApplicationUser> users, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBeanCollection(users, loggedInUser, urls, emailFormatter, timeZoneManager);
    }

    @Deprecated
    public static UserJsonBean shortBean(ApplicationUser applicationUser, JiraBaseUrls urls) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(applicationUser, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), urls, ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static UserJsonBean shortBean(ApplicationUser applicationUser, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(applicationUser, loggedInUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public static UserJsonBean shortBean(ApplicationUser applicationUser, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        return ComponentAccessor.getComponent(UserBeanFactory.class).createBean(applicationUser, loggedInUser, urls, emailFormatter, timeZoneManager);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.self, this.name, this.key, this.emailAddress, this.avatarUrls, this.displayName, this.active, this.timeZone});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserJsonBean other = (UserJsonBean)obj;
        return Objects.equal((Object)this.self, (Object)other.self) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.key, (Object)other.key) && Objects.equal((Object)this.emailAddress, (Object)other.emailAddress) && Objects.equal(this.avatarUrls, other.avatarUrls) && Objects.equal((Object)this.displayName, (Object)other.displayName) && Objects.equal((Object)this.active, (Object)other.active) && Objects.equal((Object)this.timeZone, (Object)other.timeZone);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("self", (Object)this.self).add("name", (Object)this.name).add("key", (Object)this.key).add("emailAddress", (Object)this.emailAddress).add("avatarUrls", this.avatarUrls).add("displayName", (Object)this.displayName).add("active", this.active).add("timeZone", (Object)this.timeZone).toString();
    }

    static {
        USER_DOC_EXAMPLE.setSelf("http://www.example.com/jira/rest/api/2/user?username=fred");
        USER_DOC_EXAMPLE.setName("fred");
        UserJsonBean.USER_DOC_EXAMPLE.emailAddress = "fred@example.com";
        USER_DOC_EXAMPLE.setDisplayName("Fred F. User");
        USER_DOC_EXAMPLE.setActive(true);
        USER_DOC_EXAMPLE.setAvatarUrls(MapBuilder.newBuilder().add("16x16", "http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred").add("24x24", "http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred").add("32x32", "http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred").add("48x48", "http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred").toMap());
        USER_DOC_EXAMPLE.setTimeZone("Australia/Sydney");
        USER_SHORT_DOC_EXAMPLE.setSelf(USER_DOC_EXAMPLE.getSelf());
        USER_SHORT_DOC_EXAMPLE.setName(USER_DOC_EXAMPLE.getName());
        USER_SHORT_DOC_EXAMPLE.setDisplayName(USER_DOC_EXAMPLE.getDisplayName());
    }
}

