/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Function2;

@ExperimentalApi
public class EntityPropertyBeanSelfFunctions {
    public static Function2<Long, String, String> EMPTY = (aLong, s) -> "";

    public static Function2<Long, String, String> dashboardItemPropertySelfFunction(String dashboardId) {
        return new DashboardItemPropertySelfFunction(dashboardId);
    }

    public static class IssueTypePropertySelfFunction
    implements Function2<Long, String, String> {
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("issuetype/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    private static class DashboardItemPropertySelfFunction
    implements Function2<Long, String, String> {
        private final String dashboardId;

        public DashboardItemPropertySelfFunction(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("dashboard/%s/items/%d/properties/%s", this.dashboardId, entityId, encodedPropertyKey);
        }
    }

    public static class CommentPropertySelfFunction
    implements Function2<Long, String, String> {
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("comment/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    public static class ProjectPropertySelfFunction
    implements Function2<Long, String, String> {
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("project/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    public static class IssuePropertySelfFunction
    implements Function2<Long, String, String> {
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("issue/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }
}

