/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.user.ApplicationUserBuilder;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface UserService {
    public CreateUserValidationResult validateCreateUser(CreateUserRequest var1);

    public ApplicationUser createUser(CreateUserValidationResult var1) throws PermissionException, CreateException;

    @Nonnull
    @ExperimentalApi
    public ApplicationUserBuilder newUserBuilder(@Nonnull ApplicationUser var1);

    public CreateUserValidationResult validateCreateUserForSignup(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForSetup(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForSignupOrSetup(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForAdmin(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6);

    public CreateUserValidationResult validateCreateUserForAdmin(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6, @Nullable Long var7);

    public CreateUsernameValidationResult validateCreateUsername(ApplicationUser var1, String var2);

    public CreateUsernameValidationResult validateCreateUsername(ApplicationUser var1, String var2, Long var3);

    public ApplicationUser createUserFromSignup(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public ApplicationUser createUserWithNotification(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public ApplicationUser createUserNoNotification(CreateUserValidationResult var1) throws PermissionException, CreateException;

    public UpdateUserValidationResult validateUpdateUser(ApplicationUser var1);

    public void updateUser(UpdateUserValidationResult var1);

    public DeleteUserValidationResult validateDeleteUser(ApplicationUser var1, String var2);

    public DeleteUserValidationResult validateDeleteUser(ApplicationUser var1, ApplicationUser var2);

    public void removeUser(ApplicationUser var1, DeleteUserValidationResult var2);

    public AddUserToApplicationValidationResult validateAddUserToApplication(ApplicationUser var1, ApplicationKey var2);

    public void addUserToApplication(AddUserToApplicationValidationResult var1) throws AddException, PermissionException;

    public RemoveUserFromApplicationValidationResult validateRemoveUserFromApplication(ApplicationUser var1, ApplicationKey var2);

    public void removeUserFromApplication(RemoveUserFromApplicationValidationResult var1) throws RemoveException, PermissionException;

    @PublicApi
    public static final class CreateUserRequest {
        private final ApplicationUser loggedInUser;
        private final String username;
        private final String password;
        private final String displayName;
        private final String emailAddress;
        private final Long directoryId;
        private final String confirmPassword;
        private final Set<ApplicationKey> applicationKeys;
        private final boolean sendNotification;
        private final boolean passwordRequired;
        private final boolean performPermissionCheck;
        private final boolean skipValidation;
        private final int userEventType;

        private CreateUserRequest(@Nullable ApplicationUser loggedInUser, String username, String password, String emailAddress, String displayName, @Nullable Long directoryId, @Nullable String confirmPassword, @Nullable Set<ApplicationKey> applicationKeys, boolean sendNotification, boolean passwordRequired, boolean performPermissionCheck, boolean skipValidation, int userEventType) {
            this.loggedInUser = loggedInUser;
            this.username = username;
            this.password = password;
            this.emailAddress = emailAddress;
            this.displayName = displayName;
            this.directoryId = directoryId;
            this.confirmPassword = confirmPassword;
            this.applicationKeys = applicationKeys;
            this.sendNotification = sendNotification;
            this.passwordRequired = passwordRequired;
            this.performPermissionCheck = performPermissionCheck;
            this.skipValidation = skipValidation;
            this.userEventType = userEventType;
        }

        public static CreateUserRequest withUserDetails(@Nullable ApplicationUser loggedInUser, String username, String password, String emailAddress, String displayName) {
            return new CreateUserRequest(loggedInUser, username, password, emailAddress, displayName, null, null, null, true, false, true, false, 1);
        }

        public CreateUserRequest confirmPassword(String confirmPassword) {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, confirmPassword, this.applicationKeys, this.sendNotification, this.passwordRequired, this.performPermissionCheck, this.skipValidation, this.userEventType);
        }

        public CreateUserRequest withNoApplicationAccess() {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, (Set<ApplicationKey>)ImmutableSet.of(), this.sendNotification, this.passwordRequired, this.performPermissionCheck, this.skipValidation, this.userEventType);
        }

        public CreateUserRequest withApplicationAccess(@Nonnull Set<ApplicationKey> applicationKeys) {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, applicationKeys, this.sendNotification, this.passwordRequired, this.performPermissionCheck, this.skipValidation, this.userEventType);
        }

        public CreateUserRequest sendNotification(boolean sendNotification) {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, this.applicationKeys, sendNotification, this.passwordRequired, this.performPermissionCheck, this.skipValidation, this.userEventType);
        }

        public CreateUserRequest sendUserSignupEvent() {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, this.applicationKeys, this.sendNotification, this.passwordRequired, this.performPermissionCheck, this.skipValidation, 0);
        }

        public CreateUserRequest passwordRequired() {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, this.applicationKeys, this.sendNotification, true, this.performPermissionCheck, this.skipValidation, this.userEventType);
        }

        public CreateUserRequest performPermissionCheck(boolean performPermissionCheck) {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, this.applicationKeys, this.sendNotification, this.passwordRequired, performPermissionCheck, this.skipValidation, this.userEventType);
        }

        public CreateUserRequest inDirectory(Long directoryId) {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, directoryId, this.confirmPassword, this.applicationKeys, this.sendNotification, this.passwordRequired, this.performPermissionCheck, this.skipValidation, this.userEventType);
        }

        @Internal
        public CreateUserRequest skipValidation() {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, this.applicationKeys, this.sendNotification, this.passwordRequired, this.performPermissionCheck, true, this.userEventType);
        }

        @Internal
        public CreateUserRequest withEventUserEvent(int userEventType) {
            return new CreateUserRequest(this.loggedInUser, this.username, this.password, this.emailAddress, this.displayName, this.directoryId, this.confirmPassword, this.applicationKeys, this.sendNotification, this.passwordRequired, this.performPermissionCheck, this.skipValidation, userEventType);
        }

        public boolean requirePassword() {
            return this.passwordRequired;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public boolean defaultDirectory() {
            return this.directoryId == null;
        }

        public Long getDirectoryId() {
            return this.directoryId;
        }

        public boolean shouldConfirmPassword() {
            return this.confirmPassword != null;
        }

        public String getConfirmPassword() {
            return this.confirmPassword;
        }

        public boolean requireDefaultApplicationAccess() {
            return this.applicationKeys == null;
        }

        public Set<ApplicationKey> getApplicationKeys() {
            return this.applicationKeys;
        }

        public boolean shouldSendNotification() {
            return this.sendNotification;
        }

        public boolean shouldSendUserSignupEvent() {
            return this.userEventType == 0;
        }

        public ApplicationUser getLoggedInUser() {
            return this.loggedInUser;
        }

        public boolean shouldPerformPermissionCheck() {
            return this.performPermissionCheck;
        }

        @Internal
        boolean shouldSkipValidation() {
            return this.skipValidation;
        }

        @Internal
        int getUserEventType() {
            return this.userEventType;
        }
    }

    @PublicApi
    public static final class FieldName {
        static String EMAIL = "email";
        static String NAME = "username";
        static String FULLNAME = "fullname";
        static String PASSWORD = "password";
        static String CONFIRM_PASSWORD = "confirm";

        private FieldName() {
        }
    }

    @PublicApi
    public static final class RemoveUserFromApplicationValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser userToRemove;
        private final Set<String> applicationGroupNames;

        RemoveUserFromApplicationValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.userToRemove = null;
            this.applicationGroupNames = null;
        }

        RemoveUserFromApplicationValidationResult(ApplicationUser userToRemove, Set<String> applicationGroupNames) {
            super(new SimpleErrorCollection());
            this.userToRemove = userToRemove;
            this.applicationGroupNames = applicationGroupNames;
        }

        public ApplicationUser getUserToRemove() {
            return this.userToRemove;
        }

        public Set<String> getApplicationGroupNames() {
            return this.applicationGroupNames;
        }
    }

    @PublicApi
    public static final class AddUserToApplicationValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser userToAdd;
        private final Set<Group> applicationDefaultGroups;

        AddUserToApplicationValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.userToAdd = null;
            this.applicationDefaultGroups = null;
        }

        AddUserToApplicationValidationResult(ApplicationUser userToAdd, Set<Group> applicationDefaultGroups) {
            super(new SimpleErrorCollection());
            this.userToAdd = userToAdd;
            this.applicationDefaultGroups = applicationDefaultGroups;
        }

        public ApplicationUser getUserToAdd() {
            return this.userToAdd;
        }

        public Set<Group> getApplicationDefaultGroups() {
            return this.applicationDefaultGroups;
        }
    }

    @PublicApi
    public static final class DeleteUserValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser user;

        DeleteUserValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.user = null;
        }

        DeleteUserValidationResult(ApplicationUser user) {
            super(new SimpleErrorCollection());
            this.user = user;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public ApplicationUser getApplicationUser() {
            return this.user;
        }
    }

    @PublicApi
    public static final class UpdateUserValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser user;

        UpdateUserValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.user = null;
        }

        UpdateUserValidationResult(ApplicationUser user) {
            super(new SimpleErrorCollection());
            this.user = user;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public ApplicationUser getApplicationUser() {
            return this.user;
        }
    }

    @PublicApi
    public static final class CreateUsernameValidationResult
    extends ServiceResultImpl {
        private final String username;
        private final Long directoryId;

        public CreateUsernameValidationResult(String username, Long directoryId, ErrorCollection errorCollection) {
            super(errorCollection);
            this.username = username;
            this.directoryId = directoryId;
        }

        public String getUsername() {
            return this.username;
        }

        public Long getDirectoryId() {
            return this.directoryId;
        }
    }

    @PublicApi
    public static final class CreateUserValidationResult
    extends ServiceResultImpl {
        private final List<WebErrorMessage> passwordErrors;
        private final Set<ApplicationKey> applicationKeys;
        private final CreateUserRequest createUserRequest;

        CreateUserValidationResult(ErrorCollection errorCollection) {
            this(errorCollection, (List<WebErrorMessage>)ImmutableList.of());
        }

        CreateUserValidationResult(ErrorCollection errorCollection, List<WebErrorMessage> passwordErrors) {
            super(errorCollection);
            this.createUserRequest = null;
            this.passwordErrors = ImmutableList.copyOf(passwordErrors);
            this.applicationKeys = Collections.emptySet();
        }

        CreateUserValidationResult(String username, String password, String email, String fullname) {
            this(username, password, email, fullname, null);
        }

        CreateUserValidationResult(String username, String password, String email, String fullname, Long directoryId) {
            this(username, password, email, fullname, directoryId, Collections.emptySet());
        }

        CreateUserValidationResult(String username, String password, String email, String fullname, Long directoryId, @Nullable Set<ApplicationKey> applicationKeys) {
            super(new SimpleErrorCollection());
            this.createUserRequest = CreateUserRequest.withUserDetails(null, username, password, email, fullname).inDirectory(directoryId);
            this.passwordErrors = ImmutableList.of();
            this.applicationKeys = applicationKeys;
        }

        CreateUserValidationResult(CreateUserRequest createUserRequest, Set<ApplicationKey> applicationKeys, ErrorCollection errorCollection, List<WebErrorMessage> passwordErrors) {
            super(errorCollection);
            this.passwordErrors = passwordErrors;
            this.applicationKeys = applicationKeys;
            this.createUserRequest = createUserRequest;
        }

        CreateUserRequest getCreateUserRequest() {
            return this.createUserRequest;
        }

        boolean hasCreateUserRequest() {
            return this.createUserRequest != null;
        }

        public String getUsername() {
            return this.createUserRequest == null ? null : this.createUserRequest.getUsername();
        }

        public String getPassword() {
            return this.createUserRequest == null ? null : this.createUserRequest.getPassword();
        }

        public String getEmail() {
            return this.createUserRequest == null ? null : this.createUserRequest.getEmailAddress();
        }

        public String getFullname() {
            return this.createUserRequest == null ? null : this.createUserRequest.getDisplayName();
        }

        public Long getDirectoryId() {
            return this.createUserRequest == null ? null : this.createUserRequest.getDirectoryId();
        }

        public List<WebErrorMessage> getPasswordErrors() {
            return this.passwordErrors;
        }

        public Set<ApplicationKey> getApplicationKeys() {
            if (this.applicationKeys == null) {
                return ImmutableSet.of();
            }
            return this.applicationKeys;
        }
    }
}

