/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class PageImpl<T>
implements Page<T> {
    private final long start;
    private final long total;
    private final int size;
    private final List<T> values;

    private PageImpl(long start, long total, List<T> values) {
        this.start = start;
        this.size = values.size();
        this.total = total;
        this.values = (List)Preconditions.checkNotNull(values);
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public List<T> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageImpl page = (PageImpl)o;
        if (this.size != page.size) {
            return false;
        }
        if (this.start != page.start) {
            return false;
        }
        if (this.total != page.total) {
            return false;
        }
        return !(this.values != null ? !this.values.equals(page.values) : page.values != null);
    }

    public int hashCode() {
        int result = (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.total ^ this.total >>> 32);
        result = 31 * result + this.size;
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PageImpl{start=" + this.start + ", total=" + this.total + ", size=" + this.size + ", values=" + this.values + '}';
    }

    public static <T> Builder<T> builder(@Nonnull List<T> values) {
        return new Builder(values);
    }

    public static <T> ListPageCollector<T> collector(long start, long total) {
        return new ListPageCollector(start, total);
    }

    public static <T> Page<T> empty(PageRequest request) {
        return new Builder(Collections.emptyList()).start(request.getStart()).total(0L).create();
    }

    public static class ListPageCollector<E>
    implements Collector<E, ArrayList<E>, Page<E>> {
        private final long start;
        private final long total;

        private ListPageCollector(long start, long total) {
            this.start = start;
            this.total = total;
        }

        @Override
        public Supplier<ArrayList<E>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<ArrayList<E>, E> accumulator() {
            return ArrayList::add;
        }

        @Override
        public BinaryOperator<ArrayList<E>> combiner() {
            return (left, right) -> {
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<ArrayList<E>, Page<E>> finisher() {
            return builder -> {
                ImmutableList values = ImmutableList.copyOf((Collection)builder);
                return PageImpl.builder(values).start(this.start).total(this.total).create();
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    public static class Builder<T> {
        private final List<T> values;
        private long start;
        private long total;

        private Builder(List<T> values) {
            this.values = (List)Preconditions.checkNotNull(values);
        }

        public Builder<T> start(long start) {
            this.start = start;
            return this;
        }

        public Builder<T> total(long total) {
            this.total = total;
            return this;
        }

        public Page<T> create() {
            return new PageImpl(this.start, this.total, this.values);
        }
    }
}

