/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractNumberOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.NumericUtils;

public class NumberEqualityQueryFactory
extends AbstractNumberOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(NumberEqualityQueryFactory.class);
    private final Double emptyIndexValue;

    public NumberEqualityQueryFactory(DoubleConverter doubleConverter, Double emptyIndexValue) {
        super(doubleConverter);
        this.emptyIndexValue = Assertions.notNull("emptyIndexValue", emptyIndexValue);
    }

    public NumberEqualityQueryFactory(DoubleConverter doubleConverter) {
        super(doubleConverter);
        this.emptyIndexValue = null;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.debug((Object)String.format("Creating an equality query for a single value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", new Object[]{fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS}));
            return QueryFactoryResult.createFalseResult();
        }
        return this.createResult(fieldName, operator, rawValues);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(fieldName, operator, rawValues);
        }
        log.debug((Object)String.format("Creating an equality query for multiple values for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", new Object[]{fieldName, operator, Operator.IN, Operator.NOT_IN}));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery(fieldName));
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        log.debug((Object)String.format("Creating an equality query for an empty value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s','%s', '%s' and '%s'", new Object[]{fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS}));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    private QueryFactoryResult createResult(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(fieldName, this.getIndexValues(rawValues));
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(fieldName, this.getIndexValues(rawValues));
        }
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleIn(String fieldName, List<Double> values) {
        if (values.size() == 1) {
            Double value = values.get(0);
            Query query = value == null ? this.getIsEmptyQuery(fieldName) : this.getTermQuery(fieldName, value);
            return new QueryFactoryResult(query);
        }
        BooleanQuery combined = new BooleanQuery();
        for (Double value : values) {
            if (value == null) {
                combined.add(this.getIsEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
                continue;
            }
            combined.add(this.getTermQuery(fieldName, value), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)combined);
    }

    private QueryFactoryResult handleNotIn(String fieldName, List<Double> values) {
        ArrayList notQueries = Lists.newArrayListWithCapacity((int)values.size());
        for (Double indexValue : values) {
            if (indexValue == null) continue;
            notQueries.add(this.getTermQuery(fieldName, indexValue));
        }
        if (notQueries.isEmpty()) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        BooleanQuery boolQuery = new BooleanQuery();
        boolQuery.add(this.getIsNotEmptyQuery(fieldName), BooleanClause.Occur.MUST);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.MUST);
        return new QueryFactoryResult((Query)boolQuery, false);
    }

    private Query getIsEmptyQuery(String fieldName) {
        if (this.emptyIndexValue != null) {
            return this.getTermQuery(fieldName, this.emptyIndexValue);
        }
        QueryFactoryResult result = new QueryFactoryResult(TermQueryFactory.nonEmptyQuery("sort_" + fieldName), true);
        return QueryFactoryResult.wrapWithVisibilityQuery(fieldName, result).getLuceneQuery();
    }

    private Query getIsNotEmptyQuery(String fieldName) {
        if (this.emptyIndexValue != null) {
            QueryFactoryResult result = new QueryFactoryResult(this.getTermQuery(fieldName, this.emptyIndexValue), true);
            return QueryFactoryResult.wrapWithVisibilityQuery(fieldName, result).getLuceneQuery();
        }
        return TermQueryFactory.nonEmptyQuery("sort_" + fieldName);
    }

    private Query getTermQuery(String fieldName, Double value) {
        return new TermQuery(new Term("sort_" + fieldName, NumericUtils.doubleToPrefixCoded((double)value)));
    }
}

