/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.DateSearchRendererViewHtmlMessageProvider;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.jira.web.action.util.CalendarResourceIncluder;
import com.atlassian.query.Query;
import java.util.Map;
import webwork.action.Action;

@Internal
public abstract class AbstractDateSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final CalendarLanguageUtil calendarUtils;
    private final DateSearcherConfig config;
    private final TranslationsHelper translationHelper;
    private final SimpleFieldSearchConstants constants;
    private final String searchNameKey;

    public AbstractDateSearchRenderer(SimpleFieldSearchConstants constants, DateSearcherConfig config, TranslationsHelper translationHelper, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String searcherNameKey, CalendarLanguageUtil calendarUtils) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, constants, searcherNameKey);
        this.constants = Assertions.notNull("constants", constants);
        this.config = Assertions.notNull("config", config);
        this.calendarUtils = Assertions.notNull("calendarUtils", calendarUtils);
        this.translationHelper = Assertions.notNull("translationHelper", translationHelper);
        this.searchNameKey = searcherNameKey;
    }

    @Override
    public abstract boolean isShown(ApplicationUser var1, SearchContext var2);

    @Override
    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderEditTemplate("date-searcher-edit.vm", this.addEditParameters(user, velocityParams));
    }

    private Map<String, Object> addEditParameters(ApplicationUser searcher, Map<String, Object> velocityParams) {
        I18nHelper i18n = this.getI18n(searcher);
        String language = i18n.getLocale().getLanguage();
        velocityParams.put("hasCalendarTranslation", this.calendarUtils.hasTranslationForLanguage(language));
        velocityParams.put("calendarIncluder", new CalendarResourceIncluder());
        velocityParams.put("fieldName", this.config.getFieldName());
        return this.addCommonParameters(searcher, velocityParams);
    }

    @Override
    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderViewTemplate("date-searcher-view.vm", this.addViewParameters(user, velocityParams, fieldValuesHolder));
    }

    private Map<String, Object> addViewParameters(ApplicationUser searcher, Map<String, Object> velocityParams, FieldValuesHolder fieldValuesHolder) {
        DateSearchRendererViewHtmlMessageProvider provider = new DateSearchRendererViewHtmlMessageProvider(this.getI18n(searcher), fieldValuesHolder, this.config, this.searchNameKey);
        DateSearchRendererViewHtmlMessageProvider.Result result = provider.getResult();
        if (result != null) {
            velocityParams.put("message", result.message);
            velocityParams.put("previous", result.previous);
            velocityParams.put("next", result.next);
        }
        return this.addCommonParameters(searcher, velocityParams);
    }

    private Map<String, Object> addCommonParameters(ApplicationUser searcher, Map<String, Object> velocityParams) {
        velocityParams.put("afterField", this.config.getAfterField());
        velocityParams.put("beforeField", this.config.getBeforeField());
        velocityParams.put("previousField", this.config.getPreviousField());
        velocityParams.put("nextField", this.config.getNextField());
        velocityParams.put("id", this.config.getId());
        I18nHelper i18n = this.getI18n(searcher);
        velocityParams.put("afterFieldLabel", this.translationHelper.getAfterLabel(i18n));
        velocityParams.put("beforeFieldLabel", this.translationHelper.getBeforeLabel(i18n));
        velocityParams.put("periodLabel", this.translationHelper.getPeriodLabel(i18n));
        velocityParams.put("description", this.translationHelper.getDescription(i18n));
        return velocityParams;
    }

    @Override
    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }

    public static interface TranslationsHelper {
        public String getBeforeLabel(I18nHelper var1);

        public String getAfterLabel(I18nHelper var1);

        public String getPeriodLabel(I18nHelper var1);

        public String getDescription(I18nHelper var1);
    }
}

