/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.PropertiesAccessor;
import com.atlassian.jira.config.properties.PropertiesProcessor;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;

@Internal
public class JiraPropertiesImpl
implements JiraProperties {
    private final PropertiesAccessor accessor;

    public JiraPropertiesImpl(PropertiesAccessor propertiesAccessor) {
        this.accessor = propertiesAccessor;
    }

    @Override
    public String getProperty(String key) {
        return key == null ? null : this.accessor.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultString) {
        String value = this.getProperty(key);
        return value == null ? defaultString : value;
    }

    @Override
    public <T> void setProperty(String key, T value) {
        if (value == null) {
            this.unsetProperty(key);
        } else {
            this.accessor.setProperty(key, value.toString());
        }
    }

    @Override
    public void unsetProperty(String key) {
        this.accessor.unsetProperty(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        return key == null ? null : this.accessor.getBoolean(key);
    }

    @Override
    public Integer getInteger(String key) {
        return key == null ? null : this.accessor.getInteger(key);
    }

    @Override
    public Integer getInteger(String key, Integer defaultInteger) {
        Integer value = this.getInteger(key);
        return value == null ? defaultInteger : value;
    }

    @Override
    public Long getLong(String key) {
        return key == null ? null : this.accessor.getLong(key);
    }

    @Override
    public Long getLong(String key, Long defaultLong) {
        Long value = this.getLong(key);
        return value == null ? defaultLong : value;
    }

    @Override
    public Properties getProperties() {
        return this.accessor.getProperties();
    }

    @Override
    public Map<String, String> getSanitisedProperties() {
        return new PropertiesProcessor(this.getProperties()).sanitisePassword().sort().toMap();
    }

    @Override
    public void setProperties(Properties props) {
        Preconditions.checkNotNull((Object)props);
        this.accessor.setProperties(props);
    }

    @Override
    public void refresh() {
        this.accessor.refresh();
    }

    @Override
    public boolean isDevMode() {
        return this.getBoolean("jira.dev.mode") != false || this.getBoolean("atlassian.dev.mode") != false;
    }

    @Override
    public boolean isXsrfDetectionCheckRequired() {
        return this.getBoolean("xsrf.detection.check");
    }

    @Override
    public boolean isSuperBatchingDisabled() {
        return this.getBoolean("jira.superbatching.disabled");
    }

    @Override
    public boolean isDecodeMailParameters() {
        return this.getBoolean("mail.mime.decodeparameters");
    }

    @Override
    public boolean isCustomPathPluginsEnabled() {
        return this.getProperty("atlassian.jira.plugin.scan.directory") != null;
    }

    @Override
    public String getCustomDirectoryPlugins() {
        return this.getProperty("atlassian.jira.plugin.scan.directory");
    }

    @Override
    public boolean isPluginsRosterFileEnabled() {
        return this.getProperty("atlassian.jira.plugin.roster.file") != null;
    }

    @Override
    public String getPluginsRosterFile() {
        return this.getProperty("atlassian.jira.plugin.roster.file");
    }

    @Override
    public boolean isWebSudoDisabled() {
        return this.getBoolean("jira.websudo.is.disabled");
    }

    @Override
    public boolean isI18nReloadBundles() {
        return this.getBoolean("jira.i18n.reloadbundles");
    }

    @Override
    public boolean showPerformanceMonitor() {
        return this.getBoolean("jira.show.perf.monitor");
    }

    @Override
    public boolean isBundledPluginsDisabled() {
        return this.getBoolean("jira.plugins.bundled.disable");
    }

    @Override
    public boolean isDarkFeaturesDisabled() {
        return this.getBoolean("atlassian.darkfeature.disabled");
    }

    @Override
    public boolean isXsrfDiagnostics() {
        return this.getBoolean("jira.xsrf.diagnostics");
    }

    @Override
    public boolean isResourceBundleCacheCleaningDisabled() {
        return this.getBoolean("resource.bundle.cache.clean.disable");
    }
}

