/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.user.ApplicationUser;

@PublicApi
public class ProjectCreationData {
    private final String name;
    private final String key;
    private final String description;
    private final ProjectTypeKey projectTypeKey;
    private final ProjectTemplateKey projectTemplateKey;
    private final ApplicationUser lead;
    private final String url;
    private final Long assigneeType;
    private final Long avatarId;

    private ProjectCreationData(String name, String key, String description, ProjectTypeKey projectTypeKey, ProjectTemplateKey projectTemplateKey, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        this.name = name;
        this.key = key;
        this.description = description;
        this.projectTypeKey = projectTypeKey;
        this.projectTemplateKey = projectTemplateKey;
        this.lead = lead;
        this.url = url;
        this.assigneeType = assigneeType;
        this.avatarId = avatarId;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public ProjectTypeKey getProjectTypeKey() {
        return this.projectTypeKey;
    }

    public ProjectTemplateKey getProjectTemplateKey() {
        return this.projectTemplateKey;
    }

    public ApplicationUser getLead() {
        return this.lead;
    }

    public String getUrl() {
        return this.url;
    }

    public Long getAssigneeType() {
        return this.assigneeType;
    }

    public Long getAvatarId() {
        return this.avatarId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectCreationData that = (ProjectCreationData)o;
        if (this.assigneeType != null ? !this.assigneeType.equals(that.assigneeType) : that.assigneeType != null) {
            return false;
        }
        if (this.avatarId != null ? !this.avatarId.equals(that.avatarId) : that.avatarId != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.lead != null ? !this.lead.equals(that.lead) : that.lead != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.projectTypeKey != null ? !this.projectTypeKey.equals(that.projectTypeKey) : that.projectTypeKey != null) {
            return false;
        }
        if (this.projectTemplateKey != null ? !this.projectTemplateKey.equals(that.projectTemplateKey) : that.projectTemplateKey != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.projectTypeKey != null ? this.projectTypeKey.hashCode() : 0);
        result = 31 * result + (this.projectTemplateKey != null ? this.projectTemplateKey.hashCode() : 0);
        result = 31 * result + (this.lead != null ? this.lead.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.assigneeType != null ? this.assigneeType.hashCode() : 0);
        result = 31 * result + (this.avatarId != null ? this.avatarId.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String name;
        private String key;
        private String description;
        private ProjectTypeKey projectTypeKey;
        private ProjectTemplateKey projectTemplateKey;
        private ApplicationUser lead;
        private String url;
        private Long assigneeType;
        private Long avatarId;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withType(String projectTypeKey) {
            return this.withType(new ProjectTypeKey(projectTypeKey));
        }

        public Builder withType(ProjectTypeKey projectTypeKey) {
            this.projectTypeKey = projectTypeKey;
            return this;
        }

        public Builder withProjectTemplateKey(String projectTemplateKey) {
            this.projectTemplateKey = new ProjectTemplateKey(projectTemplateKey);
            return this;
        }

        public Builder withLead(ApplicationUser lead) {
            this.lead = lead;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withAssigneeType(Long assigneeType) {
            this.assigneeType = assigneeType;
            return this;
        }

        public Builder withAvatarId(Long avatarId) {
            this.avatarId = avatarId;
            return this;
        }

        public ProjectCreationData build() {
            return new ProjectCreationData(this.name, this.key, this.description, this.projectTypeKey, this.projectTemplateKey, this.lead, this.url, this.assigneeType, this.avatarId);
        }

        public Builder from(ProjectCreationData data) {
            this.name = data.getName();
            this.key = data.getKey();
            this.description = data.getDescription();
            this.projectTypeKey = data.getProjectTypeKey();
            this.projectTemplateKey = data.getProjectTemplateKey();
            this.lead = data.getLead();
            this.url = data.getUrl();
            this.assigneeType = data.getAssigneeType();
            this.avatarId = data.getAvatarId();
            return this;
        }
    }
}

