/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDetails;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface UserManager {
    public int getTotalUserCount();

    @Nonnull
    @Deprecated
    public Set<ApplicationUser> getAllUsers();

    @Nonnull
    @Deprecated
    public Collection<ApplicationUser> getUsers();

    @Nonnull
    @Deprecated
    public Collection<ApplicationUser> getAllApplicationUsers();

    public ApplicationUser getUser(@Nullable String var1);

    public ApplicationUser getUserObject(@Nullable String var1);

    @Nullable
    public ApplicationUser getUserByKey(@Nullable String var1);

    @Nullable
    public ApplicationUser getUserByName(@Nullable String var1);

    @Nullable
    public ApplicationUser getUserByKeyEvenWhenUnknown(@Nullable String var1);

    @Nullable
    public ApplicationUser getUserByNameEvenWhenUnknown(@Nullable String var1);

    @Nullable
    public ApplicationUser findUserInDirectory(@Nullable String var1, Long var2);

    @Nullable
    public ApplicationUser getUserEvenWhenUnknown(@Nullable String var1);

    public boolean canUpdateUser(@Nonnull ApplicationUser var1);

    @ExperimentalApi
    public boolean userCanUpdateOwnDetails(@Nonnull ApplicationUser var1);

    public boolean canRenameUser(@Nullable ApplicationUser var1);

    public void updateUser(ApplicationUser var1);

    public boolean canUpdateUserPassword(@Nullable ApplicationUser var1);

    public boolean canUpdateGroupMembershipForUser(ApplicationUser var1);

    @Deprecated
    public Set<Group> getAllGroups();

    @Deprecated
    public Collection<Group> getGroups();

    public Group getGroup(@Nullable String var1);

    public Group getGroupObject(@Nullable String var1);

    @Nonnull
    public List<Directory> getWritableDirectories();

    public boolean hasWritableDirectory();

    public boolean hasPasswordWritableDirectory();

    public boolean hasGroupWritableDirectory();

    public boolean canDirectoryUpdateUserPassword(@Nullable Directory var1);

    public Directory getDirectory(Long var1);

    public boolean isUserExisting(@Nullable ApplicationUser var1);

    @Nonnull
    public String generateRandomPassword();

    @ExperimentalApi
    @Nonnull
    public UserState getUserState(@Nonnull String var1, long var2);

    @ExperimentalApi
    @Nonnull
    public UserState getUserState(@Nullable ApplicationUser var1);

    @Nonnull
    @ExperimentalApi
    public ApplicationUser createUser(@Nonnull UserDetails var1) throws CreateException, PermissionException;

    @ExperimentalApi
    public static enum UserState {
        INVALID_USER,
        SHADOW_USER,
        NORMAL_USER,
        NORMAL_USER_WITH_SHADOW;


        public boolean isEffective() {
            return this == NORMAL_USER || this == NORMAL_USER_WITH_SHADOW;
        }

        public boolean isValid() {
            return this != INVALID_USER;
        }

        public boolean isInMultipleDirectories() {
            return this == SHADOW_USER || this == NORMAL_USER_WITH_SHADOW;
        }
    }
}

