/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.context.Sink;
import com.atlassian.jira.util.dbc.Assertions;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@Internal
class LoggingContextSink
implements Sink {
    private final Logger log;
    private String name = "";
    private final String msg;
    private final Level level;

    LoggingContextSink(@Nonnull Logger log, @Nonnull String msg, @Nonnull Level level) {
        this.log = Assertions.notNull("log", log);
        this.msg = Assertions.notNull("msg", msg);
        this.level = Assertions.notNull("level", level);
    }

    @Override
    public void setName(String name) {
        this.name = Assertions.notNull("name", name);
    }

    @Override
    public void updateProgress(int progress) {
        this.log.log((Priority)this.level, (Object)MessageFormat.format(this.msg, progress, this.name));
    }
}

