/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.util.NumericUtils;

public class NumberCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    private final DoubleConverter doubleConverter;

    public NumberCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, DoubleConverter doubleConverter) {
        super(fieldVisibilityManager, Assertions.notNull("customField", customField));
        this.doubleConverter = Assertions.notNull("doubleConverter", doubleConverter);
        this.customField = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value != null) {
            String string = this.doubleConverter.getStringForLucene((Double)value);
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), string, Field.Store.YES, searchable ? Field.Index.NOT_ANALYZED_NO_NORMS : Field.Index.NO));
        }
        if (searchable) {
            String encoded = NumericUtils.doubleToPrefixCoded((double)(value != null ? (Double)value : Double.MAX_VALUE));
            doc.add((Fieldable)new Field("sort_" + this.getDocumentFieldId(), encoded, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }
}

