/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.annotations.PublicApi;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public class IssueIndexingParams {
    public static IssueIndexingParams INDEX_NONE = new IssueIndexingParams(false, false, false, false);
    public static IssueIndexingParams INDEX_ISSUE_ONLY = new IssueIndexingParams(true, false, false, false);
    public static IssueIndexingParams INDEX_ALL = new IssueIndexingParams(true, true, true, true);
    private final boolean indexIssues;
    private final boolean indexChangeHistory;
    private final boolean indexComments;
    private final boolean indexWorklogs;

    private IssueIndexingParams(boolean indexIssues, boolean indexChangeHistory, boolean indexComments, boolean indexWorklogs) {
        this.indexIssues = indexIssues;
        this.indexChangeHistory = indexChangeHistory;
        this.indexComments = indexComments;
        this.indexWorklogs = indexWorklogs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isIndexIssues() {
        return this.indexIssues;
    }

    public boolean isIndexChangeHistory() {
        return this.indexChangeHistory;
    }

    public boolean isIndexComments() {
        return this.indexComments;
    }

    public boolean isIndexWorklogs() {
        return this.indexWorklogs;
    }

    public boolean isIndex() {
        return this.indexIssues || this.indexChangeHistory || this.indexComments || this.indexWorklogs;
    }

    public boolean isIndexAll() {
        return this.indexIssues && this.indexChangeHistory && this.indexComments && this.indexWorklogs;
    }

    public String toString() {
        return "{indexIssues=" + this.indexIssues + ", indexChangeHistory=" + this.indexChangeHistory + ", indexComments=" + this.indexComments + ", indexWorklogs=" + this.indexWorklogs + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueIndexingParams that = (IssueIndexingParams)o;
        if (this.indexChangeHistory != that.indexChangeHistory) {
            return false;
        }
        if (this.indexComments != that.indexComments) {
            return false;
        }
        if (this.indexIssues != that.indexIssues) {
            return false;
        }
        return this.indexWorklogs == that.indexWorklogs;
    }

    public int hashCode() {
        int result = this.indexIssues ? 1 : 0;
        result = 31 * result + (this.indexChangeHistory ? 1 : 0);
        result = 31 * result + (this.indexComments ? 1 : 0);
        result = 31 * result + (this.indexWorklogs ? 1 : 0);
        return result;
    }

    public static class Builder {
        private boolean indexIssues = true;
        private boolean indexChangeHistory = false;
        private boolean indexComments = false;
        private boolean indexWorklogs = false;

        public Builder addIndexingParams(IssueIndexingParams issueIndexingParams) {
            this.indexIssues |= issueIndexingParams.indexIssues;
            this.indexChangeHistory |= issueIndexingParams.indexChangeHistory;
            this.indexComments |= issueIndexingParams.indexComments;
            this.indexWorklogs |= issueIndexingParams.indexWorklogs;
            return this;
        }

        public Builder setIssues(boolean indexIssues) {
            this.indexIssues = indexIssues;
            return this;
        }

        public Builder setChangeHistory(boolean indexChangeHistory) {
            this.indexChangeHistory = indexChangeHistory;
            return this;
        }

        public Builder setComments(boolean indexComments) {
            this.indexComments = indexComments;
            return this;
        }

        public Builder setWorklogs(boolean indexWorklogs) {
            this.indexWorklogs = indexWorklogs;
            return this;
        }

        public Builder withChangeHistory() {
            this.indexChangeHistory = true;
            return this;
        }

        public Builder withComments() {
            this.indexComments = true;
            return this;
        }

        public Builder withWorklogs() {
            this.indexWorklogs = true;
            return this;
        }

        public Builder withoutIssues() {
            this.indexIssues = false;
            return this;
        }

        public IssueIndexingParams build() {
            return new IssueIndexingParams(this.indexIssues, this.indexChangeHistory, this.indexComments, this.indexWorklogs);
        }
    }
}

