/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.UserCustomFieldSearchRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.UserPickerCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.UserCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.UserFitsNavigatorHelper;
import com.atlassian.jira.issue.statistics.CustomFieldUserStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.UserCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.validator.UserCustomFieldValidator;
import com.atlassian.jira.jql.values.UserClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

@PublicSpi
@PublicApi
public class UserPickerSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private final JqlOperandResolver operandResolver;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JiraAuthenticationContext context;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private final UserConverter userConverter;
    private final UserResolver userResolver;
    private final UserSearchService userSearchService;
    private UserManager userManager;
    private CustomFieldInputHelper customFieldInputHelper;
    private I18nHelper.BeanFactory beanFactory = ComponentAccessor.getI18nHelperFactory();

    public UserPickerSearcher(UserResolver userResolver, JqlOperandResolver operandResolver, JiraAuthenticationContext context, UserConverter userConverter, UserSearchService userSearchService, CustomFieldInputHelper customFieldInputHelper, UserManager userManager, FieldVisibilityManager fieldVisibilityManager) {
        this.userSearchService = userSearchService;
        this.userManager = userManager;
        this.userResolver = Assertions.notNull("userResolver", userResolver);
        this.userConverter = Assertions.notNull("userConverter", userConverter);
        this.context = Assertions.notNull("context", context);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.fieldVisibilityManager = Assertions.notNull("fieldVisibilityManager", fieldVisibilityManager);
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
    }

    @Override
    public void init(CustomField field) {
        UserCustomFieldIndexer indexer = new UserCustomFieldIndexer(this.fieldVisibilityManager, field, this.userConverter);
        UserFitsNavigatorHelper userFitsNavigatorHelper = new UserFitsNavigatorHelper(this.userSearchService);
        ClauseNames names = field.getClauseNames();
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new UserCustomFieldSearchRenderer(names, this.getDescriptor(), field, customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new UserPickerCustomFieldSearchInputTransformer(this.searcherInformation.getId(), names, field, this.userConverter, userFitsNavigatorHelper, this.customFieldInputHelper);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldValueGeneratingClauseHandler(new UserCustomFieldValidator(this.userResolver, this.operandResolver, this.beanFactory), new UserCustomFieldClauseQueryFactory(field.getId(), this.userResolver, this.operandResolver), new UserClauseValuesGenerator(this.userSearchService), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.USER);
    }

    @Override
    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    @Override
    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    @Override
    public LuceneFieldSorter getSorter(CustomField customField) {
        return new CustomFieldUserStatisticsMapper(customField, this.userManager, this.context, this.customFieldInputHelper);
    }

    @Override
    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new CustomFieldUserStatisticsMapper(customField, this.userManager, this.context, this.customFieldInputHelper);
    }
}

