/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.annotations.PublicApi;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@PublicApi
public final class ApplicationUserCreationTemplate {
    private final String username;
    private final String password;
    private final String displayName;
    private final String emailAddress;
    private final Optional<Long> directoryId;
    private final Set<ApplicationKey> applicationKeys;

    private ApplicationUserCreationTemplate(String username, String displayName, String password, String emailAddress, Long directoryId, Set<ApplicationKey> applicationKeys) {
        this.username = Assertions.notNull("username", username);
        this.displayName = Assertions.notNull("displayName", displayName);
        this.password = password;
        this.emailAddress = emailAddress;
        this.directoryId = directoryId == null ? Optional.empty() : Optional.of(directoryId);
        this.applicationKeys = applicationKeys == null ? ImmutableSet.of() : applicationKeys;
    }

    public ApplicationUserCreationTemplate(String username, String displayName) {
        this(username, displayName, null, null, null, null);
    }

    public ApplicationUserCreationTemplate withPassword(String password) {
        return new ApplicationUserCreationTemplate(this.username, this.displayName, password, this.emailAddress, this.directoryId.orElse(null), this.applicationKeys);
    }

    public ApplicationUserCreationTemplate withEmail(String email) {
        return new ApplicationUserCreationTemplate(this.username, this.displayName, this.password, email, this.directoryId.orElse(null), this.applicationKeys);
    }

    public ApplicationUserCreationTemplate withDirectory(Long directoryId) {
        return new ApplicationUserCreationTemplate(this.username, this.displayName, this.password, this.emailAddress, directoryId, this.applicationKeys);
    }

    public ApplicationUserCreationTemplate withApplications(Set<ApplicationKey> applications) {
        return new ApplicationUserCreationTemplate(this.username, this.displayName, this.password, this.emailAddress, this.directoryId.orElse(null), applications);
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Optional<Long> getDirectoryId() {
        return this.directoryId;
    }

    @Nonnull
    public Set<ApplicationKey> getApplicationKeys() {
        return this.applicationKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationUserCreationTemplate)) {
            return false;
        }
        ApplicationUserCreationTemplate that = (ApplicationUserCreationTemplate)o;
        if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) {
            return false;
        }
        if (!this.displayName.equals(that.displayName)) {
            return false;
        }
        if (this.emailAddress != null ? !this.emailAddress.equals(that.emailAddress) : that.emailAddress != null) {
            return false;
        }
        if (this.applicationKeys != null ? !this.applicationKeys.equals(that.applicationKeys) : that.applicationKeys != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.username.equals(that.username);
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + this.displayName.hashCode();
        result = 31 * result + (this.emailAddress != null ? this.emailAddress.hashCode() : 0);
        result = 31 * result + (this.directoryId != null ? this.directoryId.hashCode() : 0);
        result = 31 * result + (this.applicationKeys != null ? this.applicationKeys.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ApplicationUserRequestImpl{username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", displayName='" + this.displayName + '\'' + ", emailAddress='" + this.emailAddress + '\'' + ", directoryId=" + this.directoryId + ", getApplicationKeys=" + this.applicationKeys + '}';
    }
}

