/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.MailUtils;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;

@Internal
public class MessageUserProcessorImpl
implements MessageUserProcessor {
    private final UserManager userManager;

    public MessageUserProcessorImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    @Nullable
    public ApplicationUser getAuthorFromSender(Message message) throws MessagingException {
        String emailAddress;
        List senders = MailUtils.getSenders((Message)message);
        ApplicationUser user = null;
        Iterator iterator = senders.iterator();
        while (iterator.hasNext() && (user = this.findUserByEmail(emailAddress = (String)iterator.next())) == null && (user = this.findUserByUsername(emailAddress)) == null) {
        }
        return user;
    }

    @Override
    @Nullable
    public ApplicationUser findUserByUsername(String username) {
        return this.userManager.getUserObject(username);
    }

    @Override
    @Nullable
    public ApplicationUser findUserByEmail(String emailAddress) {
        for (ApplicationUser user : this.userManager.getAllUsers()) {
            if (!emailAddress.equalsIgnoreCase(user.getEmailAddress())) continue;
            return user;
        }
        return null;
    }
}

