/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractPermissionCondition;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.conditions.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.google.common.base.Supplier;
import java.util.Map;

@ExperimentalApi
@PublicSpi
public abstract class AbstractFixedPermissionCondition
extends AbstractWebCondition {
    protected final PermissionManager permissionManager;
    protected final int permission;

    public AbstractFixedPermissionCondition(PermissionManager permissionManager, int permission) {
        this.permissionManager = permissionManager;
        this.permission = permission;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
        super.init(params);
    }

    @Override
    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return RequestCachingConditionHelper.cacheConditionResultInRequest(AbstractPermissionCondition.getHasPermissionKey(this.permission, user, new Object[0]), (Supplier<Boolean>)((Supplier)() -> this.permissionManager.hasPermission(this.permission, user)));
    }
}

