/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;

public class DefaultUserBeanFactory
implements UserBeanFactory {
    private final JiraBaseUrls jiraBaseUrls;
    private final EmailFormatter emailFormatter;
    private final TimeZoneManager timeZoneManager;

    @Deprecated
    public DefaultUserBeanFactory(JiraBaseUrls jiraBaseUrls) {
        this(jiraBaseUrls, ComponentAccessor.getComponent(EmailFormatter.class), ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    @Deprecated
    public DefaultUserBeanFactory(JiraBaseUrls jiraBaseUrls, EmailFormatter emailFormatter) {
        this(jiraBaseUrls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
    }

    public DefaultUserBeanFactory(JiraBaseUrls jiraBaseUrls, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.emailFormatter = emailFormatter;
        this.timeZoneManager = timeZoneManager;
    }

    private static Map<String, String> getAvatarURLs(ApplicationUser user) {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        HashMap<String, String> avatarUrls = new HashMap<String, String>();
        for (Avatar.Size size : Avatar.Size.values()) {
            int px = size.getPixels();
            if (px > 48) continue;
            String sizeName = String.format("%dx%d", px, px);
            avatarUrls.put(sizeName, avatarService.getAvatarAbsoluteURL(user, user, size).toString());
        }
        return avatarUrls;
    }

    @Override
    @Deprecated
    public UserJsonBean createBean(User createdUser) {
        ApplicationUser applicationUser = ApplicationUsers.from(createdUser);
        return this.createBean(applicationUser, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser());
    }

    @Override
    @Deprecated
    public UserJsonBean createBean(User createdUser, ApplicationUser loggedInUser) {
        ApplicationUser applicationUser = ApplicationUsers.from(createdUser);
        return this.createBean(applicationUser, loggedInUser);
    }

    @Override
    public UserJsonBean createBean(User createdUser, ApplicationUser loggedInUser, JiraBaseUrls jiraBaseUrls, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        ApplicationUser applicationUser = ApplicationUsers.from(createdUser);
        return this.createBean(applicationUser, loggedInUser, jiraBaseUrls, emailFormatter, timeZoneManager);
    }

    @Override
    public UserJsonBean createBean(ApplicationUser createdUser, ApplicationUser loggedInUser) {
        return this.createBean(createdUser, loggedInUser, this.jiraBaseUrls, this.emailFormatter, this.timeZoneManager);
    }

    @Override
    public UserJsonBean createBean(ApplicationUser createdUser, ApplicationUser loggedInUser, JiraBaseUrls jiraBaseUrls, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager) {
        if (createdUser == null) {
            return null;
        }
        TimeZone timeZone = timeZoneManager.getTimeZoneforUser(createdUser.getDirectoryUser());
        UserJsonBean bean = new UserJsonBean();
        bean.setSelf(jiraBaseUrls.restApi2BaseUrl() + "user?username=" + JiraUrlCodec.encode(createdUser.getUsername()));
        bean.setName(createdUser.getUsername());
        bean.setDisplayName(createdUser.getDisplayName());
        bean.setEmailAddress(createdUser.getEmailAddress(), loggedInUser, emailFormatter);
        bean.setActive(createdUser.isActive());
        bean.setAvatarUrls(DefaultUserBeanFactory.getAvatarURLs(createdUser));
        bean.setTimeZone(timeZone != null ? timeZone.getID() : null);
        bean.setKey(createdUser.getKey());
        return bean;
    }

    @Override
    public Collection<UserJsonBean> createBeanCollection(Collection<ApplicationUser> createdUsers, ApplicationUser loggedInUser) {
        return this.createBeanCollection(createdUsers, loggedInUser, this.jiraBaseUrls, this.emailFormatter, this.timeZoneManager);
    }

    @Override
    public Collection<UserJsonBean> createBeanCollection(Collection<ApplicationUser> createdUsers, final ApplicationUser loggedInUser, final JiraBaseUrls jiraBaseUrls, final EmailFormatter emailFormatter, final TimeZoneManager timeZoneManager) {
        if (createdUsers == null) {
            return null;
        }
        return Collections2.transform(createdUsers, (Function)new Function<ApplicationUser, UserJsonBean>(){

            public UserJsonBean apply(@Nullable ApplicationUser from) {
                return DefaultUserBeanFactory.this.createBean(from, loggedInUser, jiraBaseUrls, emailFormatter, timeZoneManager);
            }
        });
    }
}

