/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.version.RemoveVersionAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface VersionService {
    public static final VersionAction REMOVE = new RemoveVersionAction();

    @Deprecated
    public ErrorCollection validateVersionDetails(User var1, Version var2, String var3, String var4);

    @Deprecated
    public ServiceOutcome<Version> setVersionDetails(User var1, Version var2, String var3, String var4);

    @Deprecated
    public ServiceOutcome<Version> setReleaseDate(User var1, Version var2, Date var3);

    @Deprecated
    public ServiceOutcome<Version> validateReleaseDate(User var1, Version var2, String var3);

    @Deprecated
    public ServiceOutcome<Version> setReleaseDate(User var1, Version var2, String var3);

    public ValidationResult validateDelete(JiraServiceContext var1, Long var2, VersionAction var3, VersionAction var4);

    public void delete(JiraServiceContext var1, ValidationResult var2);

    public ValidationResult validateMerge(JiraServiceContext var1, Long var2, Long var3);

    public void merge(JiraServiceContext var1, ValidationResult var2);

    @Deprecated
    public VersionResult getVersionById(User var1, Project var2, Long var3);

    public VersionResult getVersionById(ApplicationUser var1, Project var2, Long var3);

    @Deprecated
    public VersionResult getVersionById(User var1, Long var2);

    public VersionResult getVersionById(ApplicationUser var1, Long var2);

    @Deprecated
    public VersionResult getVersionByProjectAndName(User var1, Project var2, String var3);

    @Nonnull
    public VersionResult getVersionByProjectAndName(@Nullable ApplicationUser var1, @Nonnull Project var2, @Nonnull String var3);

    @Deprecated
    public VersionsResult getVersionsByProject(User var1, Project var2);

    @Nonnull
    public VersionsResult getVersionsByProject(@Nullable ApplicationUser var1, @Nonnull Project var2);

    @Deprecated
    public CreateVersionValidationResult validateCreateVersion(User var1, Project var2, String var3, String var4, String var5, Long var6);

    @Deprecated
    public CreateVersionValidationResult validateCreateVersion(User var1, Project var2, String var3, Date var4, String var5, Long var6);

    @Deprecated
    public Version createVersion(User var1, CreateVersionValidationResult var2);

    @Deprecated
    public ReleaseVersionValidationResult validateReleaseVersion(User var1, Version var2, Date var3);

    @Nonnull
    public ReleaseVersionValidationResult validateReleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nullable Date var3);

    @Deprecated
    public ReleaseVersionValidationResult validateReleaseVersion(User var1, Version var2, String var3);

    @Nonnull
    public ReleaseVersionValidationResult validateReleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nonnull String var3);

    @Deprecated
    public ReleaseVersionValidationResult validateUnreleaseVersion(User var1, Version var2, Date var3);

    @Nonnull
    public ReleaseVersionValidationResult validateUnreleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nullable Date var3);

    @Deprecated
    public ReleaseVersionValidationResult validateUnreleaseVersion(User var1, Version var2, String var3);

    @Nonnull
    public ReleaseVersionValidationResult validateUnreleaseVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nonnull String var3);

    public Version releaseVersion(ReleaseVersionValidationResult var1);

    @Deprecated
    public void moveUnreleasedToNewVersion(User var1, Version var2, Version var3);

    public void moveUnreleasedToNewVersion(@Nullable ApplicationUser var1, @Nonnull Version var2, @Nonnull Version var3);

    public Version unreleaseVersion(ReleaseVersionValidationResult var1);

    @Deprecated
    public ArchiveVersionValidationResult validateArchiveVersion(User var1, Version var2);

    @Nonnull
    public ArchiveVersionValidationResult validateArchiveVersion(@Nullable ApplicationUser var1, @Nonnull Version var2);

    @Deprecated
    public ArchiveVersionValidationResult validateUnarchiveVersion(User var1, Version var2);

    @Nonnull
    public ArchiveVersionValidationResult validateUnarchiveVersion(@Nullable ApplicationUser var1, @Nonnull Version var2);

    public Version archiveVersion(ArchiveVersionValidationResult var1);

    public Version unarchiveVersion(ArchiveVersionValidationResult var1);

    public boolean isOverdue(Version var1);

    @Deprecated
    public MoveVersionValidationResult validateMoveToStartVersionSequence(User var1, long var2);

    @Nonnull
    public MoveVersionValidationResult validateMoveToStartVersionSequence(@Nullable ApplicationUser var1, long var2);

    @Deprecated
    public MoveVersionValidationResult validateIncreaseVersionSequence(User var1, long var2);

    @Nonnull
    public MoveVersionValidationResult validateIncreaseVersionSequence(@Nullable ApplicationUser var1, long var2);

    @Deprecated
    public MoveVersionValidationResult validateDecreaseVersionSequence(User var1, long var2);

    @Nonnull
    public MoveVersionValidationResult validateDecreaseVersionSequence(@Nullable ApplicationUser var1, long var2);

    @Deprecated
    public MoveVersionValidationResult validateMoveToEndVersionSequence(User var1, long var2);

    @Nonnull
    public MoveVersionValidationResult validateMoveToEndVersionSequence(@Nullable ApplicationUser var1, long var2);

    @Deprecated
    public MoveVersionValidationResult validateMoveVersionAfter(User var1, long var2, Long var4);

    public MoveVersionValidationResult validateMoveVersionAfter(@Nullable ApplicationUser var1, long var2, @Nonnull Long var4);

    public void moveToStartVersionSequence(MoveVersionValidationResult var1);

    public void increaseVersionSequence(MoveVersionValidationResult var1);

    public void decreaseVersionSequence(MoveVersionValidationResult var1);

    public void moveToEndVersionSequence(MoveVersionValidationResult var1);

    public void moveVersionAfter(MoveVersionValidationResult var1);

    public long getFixIssuesCount(Version var1);

    public long getAffectsIssuesCount(Version var1);

    @Deprecated
    public long getUnresolvedIssuesCount(User var1, Version var2);

    public long getUnresolvedIssuesCount(@Nullable ApplicationUser var1, @Nonnull Version var2);

    public VersionBuilder newBuilder();

    public VersionBuilder newBuilder(Version var1);

    @Deprecated
    public VersionBuilderValidationResult validateCreate(User var1, VersionBuilder var2);

    @Nonnull
    public VersionBuilderValidationResult validateCreate(@Nullable ApplicationUser var1, @Nonnull VersionBuilder var2);

    @Deprecated
    public ServiceOutcome<Version> create(User var1, VersionBuilderValidationResult var2);

    @Nonnull
    public ServiceOutcome<Version> create(@Nullable ApplicationUser var1, @Nonnull VersionBuilderValidationResult var2);

    @Deprecated
    public VersionBuilderValidationResult validateUpdate(User var1, VersionBuilder var2);

    @Nonnull
    public VersionBuilderValidationResult validateUpdate(@Nullable ApplicationUser var1, @Nonnull VersionBuilder var2);

    public ServiceOutcome<Version> update(ApplicationUser var1, VersionBuilderValidationResult var2);

    @Deprecated
    public ServiceOutcome<Version> update(User var1, VersionBuilderValidationResult var2);

    public static class VersionBuilderValidationResult
    extends ReasonsServiceResult<CreateVersionValidationResult.Reason, VersionBuilder> {
        VersionBuilderValidationResult(ErrorCollection errorCollection, Set<CreateVersionValidationResult.Reason> reasons) {
            super(errorCollection, reasons);
        }

        VersionBuilderValidationResult(ErrorCollection errorCollection, Set<CreateVersionValidationResult.Reason> reasons, VersionBuilder versionBuilder) {
            super(errorCollection, reasons, versionBuilder);
        }
    }

    public static class ReasonsServiceResult<R, T>
    extends ServiceResultImpl {
        private final Set<R> specificReasons;
        private final T result;

        public ReasonsServiceResult(ErrorCollection errorCollection, Set<R> specificReasons) {
            super(errorCollection);
            this.specificReasons = Collections.unmodifiableSet(specificReasons);
            this.result = null;
        }

        public ReasonsServiceResult(ErrorCollection errorCollection, Set<R> specificReasons, T result) {
            super(errorCollection);
            this.specificReasons = Collections.unmodifiableSet(specificReasons);
            this.result = result;
        }

        public Set<R> getSpecificReasons() {
            return this.specificReasons;
        }

        public T getResult() {
            return this.result;
        }
    }

    public static class VersionBuilder {
        final Version version;
        Long projectId;
        String name;
        String description;
        Date startDate;
        Date releaseDate;
        Long scheduleAfterVersion;

        VersionBuilder() {
            this.version = null;
        }

        VersionBuilder(Version version) {
            this.version = version;
            this.projectId = version.getProjectId();
            this.name = version.getName();
            this.description = version.getDescription();
            this.startDate = version.getStartDate();
            this.releaseDate = version.getReleaseDate();
        }

        public VersionBuilder projectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        public VersionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VersionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VersionBuilder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public VersionBuilder releaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public VersionBuilder scheduleAfterVersion(Long scheduleAfterVersion) {
            this.scheduleAfterVersion = scheduleAfterVersion;
            return this;
        }

        @Deprecated
        Version save() {
            return this.build();
        }

        Version build() {
            Version newVersion = this.version.clone();
            newVersion.setName(this.name);
            newVersion.setDescription(this.description);
            newVersion.setStartDate(this.startDate);
            newVersion.setReleaseDate(this.releaseDate);
            return newVersion;
        }
    }

    @PublicApi
    public static interface VersionAction {
        public boolean isSwap();

        public Long getSwapVersionId();
    }

    @PublicApi
    public static class MoveVersionValidationResult
    extends AbstractVersionResult {
        private Long scheduleAfterVersion;
        private final Set<Reason> reasons;

        public MoveVersionValidationResult(ErrorCollection errorCollection, Set<Reason> reasons) {
            super(errorCollection);
            this.reasons = Collections.unmodifiableSet(reasons);
        }

        public MoveVersionValidationResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
            this.reasons = Collections.emptySet();
        }

        public MoveVersionValidationResult(ErrorCollection errorCollection, Version version, Long scheduleAfterVersion) {
            super(errorCollection, version);
            this.reasons = Collections.emptySet();
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public Set<Reason> getReasons() {
            return this.reasons;
        }

        public Long getScheduleAfterVersion() {
            return this.scheduleAfterVersion;
        }

        public static enum Reason {
            FORBIDDEN,
            NOT_FOUND,
            SCHEDULE_AFTER_VERSION_NOT_FOUND;

        }
    }

    @PublicApi
    public static class ArchiveVersionValidationResult
    extends AbstractVersionResult {
        public ArchiveVersionValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public ArchiveVersionValidationResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
        }
    }

    @PublicApi
    public static class ReleaseVersionValidationResult
    extends AbstractVersionResult {
        private final Date releaseDate;

        public ReleaseVersionValidationResult(ErrorCollection errorCollection) {
            this(errorCollection, null, null);
        }

        public ReleaseVersionValidationResult(ErrorCollection errorCollection, Version version, Date releaseDate) {
            super(errorCollection, version);
            this.releaseDate = releaseDate;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }
    }

    @PublicApi
    public static class VersionsResult
    extends ServiceResultImpl {
        private final Collection<Version> versions;

        public VersionsResult(ErrorCollection errorCollection) {
            this(errorCollection, Collections.emptyList());
        }

        public VersionsResult(ErrorCollection errorCollection, Collection<Version> versions) {
            super(errorCollection);
            this.versions = versions;
        }

        public Collection<Version> getVersions() {
            return this.versions;
        }
    }

    @PublicApi
    public static class VersionResult
    extends AbstractVersionResult {
        public VersionResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        public VersionResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection, version);
        }
    }

    @PublicApi
    public static abstract class AbstractVersionResult
    extends ServiceResultImpl {
        private final Version version;

        public AbstractVersionResult(ErrorCollection errorCollection) {
            this(errorCollection, null);
        }

        public AbstractVersionResult(ErrorCollection errorCollection, Version version) {
            super(errorCollection);
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }
    }

    @PublicApi
    public static class CreateVersionValidationResult
    extends ServiceResultImpl {
        private final Project project;
        private final String versionName;
        private final Date startDate;
        private final Date releaseDate;
        private final String description;
        private final Long scheduleAfterVersion;
        private final Set<Reason> reasons;

        public CreateVersionValidationResult(ErrorCollection errorCollection, Set<Reason> reasons) {
            super(errorCollection);
            this.reasons = Collections.unmodifiableSet(reasons);
            this.project = null;
            this.versionName = null;
            this.startDate = null;
            this.releaseDate = null;
            this.description = null;
            this.scheduleAfterVersion = null;
        }

        public CreateVersionValidationResult(ErrorCollection errorCollection, Project project, String versionName, Date releaseDate, String description, Long scheduleAfterVersion) {
            super(errorCollection);
            this.reasons = Collections.emptySet();
            this.project = project;
            this.versionName = versionName;
            this.startDate = null;
            this.releaseDate = releaseDate;
            this.description = description;
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public CreateVersionValidationResult(ErrorCollection errorCollection, Project project, String versionName, Date startDate, Date releaseDate, String description, Long scheduleAfterVersion) {
            super(errorCollection);
            this.reasons = Collections.emptySet();
            this.project = project;
            this.versionName = versionName;
            this.startDate = startDate;
            this.releaseDate = releaseDate;
            this.description = description;
            this.scheduleAfterVersion = scheduleAfterVersion;
        }

        public Project getProject() {
            return this.project;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public String getDescription() {
            return this.description;
        }

        public Long getScheduleAfterVersion() {
            return this.scheduleAfterVersion;
        }

        public Set<Reason> getReasons() {
            return this.reasons;
        }

        public static enum Reason {
            FORBIDDEN,
            BAD_PROJECT,
            BAD_NAME,
            DUPLICATE_NAME,
            BAD_START_DATE,
            BAD_RELEASE_DATE,
            BAD_START_RELEASE_DATE_ORDER,
            VERSION_NAME_TOO_LONG;

        }
    }

    @PublicApi
    public static interface ValidationResult {
        public boolean isValid();

        public Version getVersionToDelete();

        public Version getFixSwapVersion();

        public Version getAffectsSwapVersion();

        public Option<Version> getVersionToMergeTo();

        public Set<Reason> getReasons();

        public ErrorCollection getErrorCollection();

        public Action getAction();

        public static enum Action {
            DELETE,
            MERGE,
            DELETE_AND_REPLACE;

        }

        public static enum Reason {
            FORBIDDEN,
            NOT_FOUND,
            SWAP_TO_VERSION_INVALID;

        }
    }
}

