/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectCategoryContext;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItem;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.render.Encoder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.jira.web.action.util.CalendarResourceIncluder;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class CustomFieldUtils {
    public static final String CUSTOM_FIELD_PREFIX = "customfield_";
    @Deprecated
    public static final String PARAM_REQUIRE_PROJECT_IDS = "requireProjectIds";
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/fields/view/";
    private static final char SEARCH_PARM_KEY_SEPARATOR = ':';

    public static String getParamKeyPrefixAtl() {
        return "com.atlassian.jira.internal.";
    }

    public static String getParamKeyRequireProjectIds() {
        return CustomFieldUtils.getParamKeyPrefixAtl() + PARAM_REQUIRE_PROJECT_IDS;
    }

    public static String getSearchParamSuffix(String searchParamKey) {
        if (searchParamKey == null) {
            return null;
        }
        int indexOfSeparator = searchParamKey.indexOf(58);
        if (indexOfSeparator != -1 && indexOfSeparator != searchParamKey.length()) {
            return searchParamKey.substring(indexOfSeparator + 1);
        }
        return null;
    }

    public static String getCustomFieldKey(String searchParamKey) {
        int indexOfSeparator = searchParamKey.indexOf(58);
        return indexOfSeparator == -1 ? searchParamKey : searchParamKey.substring(0, indexOfSeparator);
    }

    public static String createSearchParam(String customFieldId, String searchParam) {
        return customFieldId + ':' + searchParam;
    }

    public static Long getCustomFieldId(String key) {
        Long id;
        if (key == null || !key.startsWith(CUSTOM_FIELD_PREFIX)) {
            return null;
        }
        int indexOfSeparator = key.indexOf(58);
        if (indexOfSeparator != -1) {
            id = new Long(key.substring(CUSTOM_FIELD_PREFIX.length(), indexOfSeparator));
        } else {
            String substring = key.substring(CUSTOM_FIELD_PREFIX.length());
            if (substring.endsWith(":after")) {
                substring = substring.substring(0, substring.length() - ":after".length());
            } else if (substring.endsWith(":before")) {
                substring = substring.substring(0, substring.length() - ":before".length());
            }
            id = new Long(substring);
        }
        return id;
    }

    public static boolean isCollectionNotEmpty(Collection stringCollection) {
        if (stringCollection != null && !stringCollection.isEmpty()) {
            for (Object o : stringCollection) {
                boolean hasValue = ObjectUtils.isValueSelected(o);
                if (!hasValue) continue;
                return hasValue;
            }
        }
        return false;
    }

    public static Map<CustomField, Object> parseCustomFieldValuesFromActionParams(Map actionParameters, List<CustomField> customFields) {
        HashMap<CustomField, Object> customFieldValues = new HashMap<CustomField, Object>();
        for (CustomField customField : customFields) {
            customFieldValues.put(customField, customField.getValueFromParams(actionParameters));
        }
        return customFieldValues;
    }

    public static List<JiraContextNode> buildJiraIssueContexts(boolean global, Long[] projectCategories, Long[] projects, JiraContextTreeManager treeManager) {
        ArrayList<JiraContextNode> contexts = new ArrayList<JiraContextNode>();
        if (global) {
            contexts.add(treeManager.getRootNode());
        } else {
            if (projectCategories != null) {
                for (Long projectCategoryId : projectCategories) {
                    ProjectCategory projectCategory = treeManager.getProjectManager().getProjectCategoryObject(projectCategoryId);
                    contexts.add(new ProjectCategoryContext(projectCategory, treeManager));
                }
            }
            if (projects != null) {
                for (Long projectId : projects) {
                    Project project = treeManager.getProjectManager().getProjectObj(projectId);
                    contexts.add(new ProjectContext(project, treeManager));
                }
            }
        }
        return contexts;
    }

    public static List<GenericValue> buildIssueTypes(ConstantsManager constantsManager, String[] issueTypes) {
        ArrayList<GenericValue> returnIssueTypes = null;
        if (issueTypes != null) {
            returnIssueTypes = new ArrayList<GenericValue>(issueTypes.length);
            for (String issuetype : issueTypes) {
                if ("-1".equals(issuetype)) {
                    returnIssueTypes.add(null);
                    continue;
                }
                returnIssueTypes.add(constantsManager.getIssueType(issuetype));
            }
        }
        return returnIssueTypes;
    }

    public static List<IssueContext> convertToIssueContexts(GenericValue project, List<String> issueTypeIds) {
        Long projectId = project == null ? null : project.getLong("id");
        return CustomFieldUtils.convertToIssueContexts(projectId, issueTypeIds);
    }

    public static List<IssueContext> convertToIssueContexts(Project project, List<String> issueTypeIds) {
        Long projectId = project == null ? null : project.getId();
        return CustomFieldUtils.convertToIssueContexts(projectId, issueTypeIds);
    }

    private static List<IssueContext> convertToIssueContexts(Long projectId, List<String> issueTypeIds) {
        ArrayList<IssueContext> issueContexts = new ArrayList<IssueContext>();
        if (issueTypeIds != null && !issueTypeIds.isEmpty()) {
            for (String issueTypeId : issueTypeIds) {
                issueContexts.add(new IssueContextImpl(projectId, issueTypeId));
            }
        } else {
            issueContexts.add(new IssueContextImpl(projectId, null));
        }
        return issueContexts;
    }

    public static boolean isUserHasPermissionToProjects(CustomField customField, User user) {
        if (customField.isAllProjects()) {
            return true;
        }
        List<Project> projects = customField.getAssociatedProjectObjects();
        if (projects != null && !projects.isEmpty()) {
            for (Project project : projects) {
                if (!ComponentAccessor.getComponent(PermissionManager.class).hasPermission(10, project, user)) continue;
                return true;
            }
        }
        return false;
    }

    public static String prettyPrintOptions(Options options) {
        Encoder encoder = ComponentAccessor.getComponent(Encoder.class);
        if (encoder == null) {
            encoder = new NullEncoder();
        }
        StringBuilder sb = new StringBuilder();
        if (options != null && !options.isEmpty()) {
            sb.append("<ul class=\"optionslist\">");
            for (Option option : options) {
                sb.append("<li>");
                sb.append(encoder.encodeForHtml(option.getValue())).append(option.getDisabled() != false ? " (" + CustomFieldUtils.getI18nBean().getText("admin.common.words.disabled") + ")" : "");
                List<Option> childOptions = option.getChildOptions();
                if (option.getChildOptions() != null && !childOptions.isEmpty()) {
                    sb.append("<ul>");
                    for (Option childOption : childOptions) {
                        sb.append("<li>").append(encoder.encodeForHtml(childOption.getValue())).append("</li>");
                    }
                    sb.append("</ul>");
                }
                sb.append("</li>");
            }
            sb.append("</ul>");
        } else {
            sb.append("No options configured.");
        }
        return sb.toString();
    }

    public static Map<String, Object> buildParams(CustomField customField, FieldConfig config, Issue issue, FieldLayoutItem fieldLayoutItem, Object value, Map customFieldValuesHolder, Action action, Map displayParameters) {
        Map<String, Object> velocityParameters;
        Map<String, Object> params = MapBuilder.newBuilder().add("customField", customField).add("issue", (CustomField)((Object)issue)).add("fieldLayoutItem", (CustomField)((Object)fieldLayoutItem)).add("action", (CustomField)action).add("displayParameters", (CustomField)((Object)displayParameters)).add("displayParams", (CustomField)((Object)displayParameters)).add("fieldValuesHolder", (CustomField)((Object)customFieldValuesHolder)).toMutableMap();
        if (displayParameters != null) {
            params.put("readOnly", (CustomField)((Object)(displayParameters.get("readonly") == null ? Boolean.FALSE : displayParameters.get("readonly"))));
            params.put("textOnly", (CustomField)((Object)(displayParameters.get("textOnly") == null ? Boolean.FALSE : displayParameters.get("textOnly"))));
            params.put("excelView", (CustomField)((Object)(displayParameters.get("excel_view") == null ? Boolean.FALSE : displayParameters.get("excel_view"))));
            params.put("noLink", (CustomField)((Object)(displayParameters.get("nolink") == null ? Boolean.FALSE : displayParameters.get("nolink"))));
            params.put("prefix", (CustomField)((Object)(displayParameters.get("prefix") == null ? "" : displayParameters.get("prefix"))));
        } else {
            params.put("readOnly", (CustomField)((Object)Boolean.FALSE));
            params.put("textOnly", (CustomField)((Object)Boolean.FALSE));
            params.put("excelView", (CustomField)((Object)Boolean.FALSE));
            params.put("noLink", (CustomField)((Object)Boolean.FALSE));
            params.put("prefix", (CustomField)((Object)""));
        }
        String language = ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLocale().getLanguage();
        params.put("hasCalendarTranslation", (CustomField)((Object)Boolean.valueOf(ComponentAccessor.getComponent(CalendarLanguageUtil.class).hasTranslationForLanguage(language))));
        params.put("calendarIncluder", (CustomField)((Object)new CalendarResourceIncluder()));
        if (customField != null && customField.isRenderable() && fieldLayoutItem != null) {
            params.put("rendererDescriptor", (CustomField)((Object)ComponentAccessor.getComponent(RendererManager.class).getRendererForType(fieldLayoutItem.getRendererType()).getDescriptor()));
            params.put("rendererParams", new HashMap());
        }
        params.put("auiparams", new HashMap());
        if (customField == null || customFieldValuesHolder == null && value != null) {
            params.put("value", (CustomField)value);
        } else {
            CustomFieldParams customFieldParams = customField.getCustomFieldValues(customFieldValuesHolder);
            params.put("value", (CustomField)customField.getCustomFieldType().getStringValueFromCustomFieldParams(customFieldParams));
            params.put("customFieldParams", (CustomField)((Object)customFieldParams));
        }
        if (customField != null && (velocityParameters = customField.getCustomFieldType().getVelocityParameters(issue, customField, fieldLayoutItem)) != null) {
            if (velocityParameters.containsKey(CustomFieldUtils.getParamKeyRequireProjectIds())) {
                params.put("projectIdList", CustomFieldUtils.getProjectIdsFromIssueOrFieldConfig(issue, config, ComponentAccessor.getFieldConfigSchemeManager(), ComponentAccessor.getProjectManager()));
            }
            params.putAll(velocityParameters);
        }
        params.put("dateFormat", (CustomField)((Object)CustomFieldUtils.getDateFormat()));
        params.put("dateTimeFormat", (CustomField)((Object)CustomFieldUtils.getDateTimeFormat()));
        params.put("timeFormat", (CustomField)((Object)CustomFieldUtils.getTimeFormat()));
        if (config != null) {
            params.put("config", config);
            List<FieldConfigItem> configItems = config.getConfigItems();
            if (configItems != null && !configItems.isEmpty()) {
                HashMap<String, Object> configs = new HashMap<String, Object>(configItems.size());
                for (FieldConfigItem configItem : configItems) {
                    configs.put(configItem.getObjectKey(), configItem.getConfigurationObject(issue));
                }
                params.put("configs", configs);
            }
        }
        return params;
    }

    public static String getDateFormat() {
        return ComponentAccessor.getComponent(ApplicationProperties.class).getDefaultBackedString("jira.date.picker.javascript.format");
    }

    public static String getDateTimeFormat() {
        return ComponentAccessor.getComponent(ApplicationProperties.class).getDefaultBackedString("jira.date.time.picker.javascript.format");
    }

    public static String getTimeFormat() {
        String dateTimeFormat = CustomFieldUtils.getDateTimeFormat();
        if (dateTimeFormat != null && (dateTimeFormat.indexOf("%H") > -1 || dateTimeFormat.indexOf("%R") > -1 || dateTimeFormat.indexOf("%k") > -1)) {
            return "24";
        }
        return "12";
    }

    protected static I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    public static boolean isShownAndVisible(CustomField customField, User user, SearchContext searchContext, FieldVisibilityManager fieldVisibilityManager) {
        return customField.isInScope(searchContext) && !fieldVisibilityManager.isFieldHiddenInAllSchemes(customField.getId(), searchContext, user);
    }

    public static Collection<Long> getProjectIdsFromIssueOrFieldConfig(Issue issue, FieldConfig config, FieldConfigSchemeManager fieldConfigSchemeManager, ProjectManager projectManager) {
        return CustomFieldUtils.getProjectIdsFromProjectOrFieldConfig(issue == null ? null : issue.getProjectId(), config, fieldConfigSchemeManager, projectManager);
    }

    public static Collection<Long> getProjectIdsFromProjectOrFieldConfig(Long projectIdFromIssue, FieldConfig config, FieldConfigSchemeManager fieldConfigSchemeManager, ProjectManager projectManager) {
        if (projectIdFromIssue != null) {
            return ImmutableList.of((Object)projectIdFromIssue);
        }
        if (config != null) {
            return CustomFieldUtils.getProjectIdsFromFieldConfig(config, fieldConfigSchemeManager, projectManager);
        }
        return null;
    }

    private static Collection<Long> getProjectIdsFromFieldConfig(FieldConfig fieldConfig, FieldConfigSchemeManager fieldConfigSchemeManager, ProjectManager projectManager) {
        FieldConfigScheme fieldConfigScheme = fieldConfigSchemeManager.getConfigSchemeForFieldConfig(fieldConfig);
        if (fieldConfigScheme != null && fieldConfigScheme.isEnabled()) {
            if (fieldConfigScheme.isGlobal()) {
                Collection allProjectIds = Collections2.transform(projectManager.getProjectObjects(), CustomFieldUtils.getProjectIdFunction());
                Collection associatedProjectIds = Collections2.transform(fieldConfig.getCustomField().getAssociatedProjectObjects(), CustomFieldUtils.getProjectIdFunction());
                return Sets.difference((Set)ImmutableSet.copyOf((Collection)allProjectIds), (Set)ImmutableSet.copyOf((Collection)associatedProjectIds));
            }
            return fieldConfigScheme.getAssociatedProjectIds();
        }
        return null;
    }

    public static Collection<Long> getProjectIdsForUser(ApplicationUser user, Collection<Long> projectIds, PermissionManager permissionManager, UserFilter userFilter) {
        if (CollectionUtils.isEmpty(projectIds)) {
            if (userFilter != null && CollectionUtils.isNotEmpty(userFilter.getRoleIds())) {
                return Collections2.transform(permissionManager.getProjects(10, user), CustomFieldUtils.getProjectIdFunction());
            }
            return ImmutableList.of();
        }
        return projectIds;
    }

    private static Function<Project, Long> getProjectIdFunction() {
        return new Function<Project, Long>(){

            public Long apply(Project project) {
                return project.getId();
            }
        };
    }

    private static class NullEncoder
    implements Encoder {
        private NullEncoder() {
        }

        @Override
        @Nonnull
        public String encodeForHtml(@Nullable Object input) {
            return input != null ? input.toString() : "";
        }
    }
}

