/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.Promise;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public interface AttachmentStore {
    @Nonnull
    public File getThumbnailDirectory(@Nonnull Issue var1);

    @Nullable
    public File getAttachmentDirectory(@Nonnull String var1);

    public File getAttachmentDirectory(@Nonnull Issue var1, boolean var2);

    public File getTemporaryAttachmentDirectory();

    public File getAttachmentDirectory(@Nonnull Issue var1);

    public File getAttachmentDirectory(String var1, String var2, String var3);

    public File getAttachmentFile(Issue var1, Attachment var2) throws DataAccessException;

    public File getAttachmentFile(Attachment var1) throws DataAccessException;

    public File getAttachmentFile(AttachmentAdapter var1, File var2);

    public Promise<Attachment> putAttachment(Attachment var1, InputStream var2);

    public Promise<Attachment> putAttachment(Attachment var1, File var2);

    public <A> Promise<A> getAttachment(Attachment var1, Function<InputStream, A> var2);

    public Promise<Void> move(Attachment var1, String var2);

    @Nonnull
    public File getThumbnailFile(Attachment var1);

    @Nonnull
    public File getThumbnailFile(@Nonnull Issue var1, Attachment var2);

    public File getLegacyThumbnailFile(Attachment var1);

    public void checkValidAttachmentDirectory(Issue var1) throws AttachmentException;

    public void checkValidTemporaryAttachmentDirectory() throws AttachmentException;

    public Option<ErrorCollection> errors();

    public Promise<Void> deleteAttachment(@Nonnull Attachment var1);

    public Promise<Void> deleteAttachmentContainerForIssue(@Nonnull Issue var1);

    public static interface AttachmentAdapter {
        public Long getId();

        public String getFilename();
    }
}

