/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class GetActionsRequest {
    private final Issue issue;
    private final User remoteUser;
    private final boolean asynchronous;
    private final boolean showAll;
    private final String focusId;

    @Internal
    public GetActionsRequest(@Nonnull Issue issue, @Nullable User remoteUser, boolean asynchronous, boolean showAll, @Nullable String focusId) {
        this.issue = Assertions.notNull(issue);
        this.remoteUser = remoteUser;
        this.asynchronous = asynchronous;
        this.showAll = showAll;
        this.focusId = focusId;
    }

    @Nonnull
    public Issue issue() {
        return this.issue;
    }

    @Nullable
    public User remoteUser() {
        return this.remoteUser;
    }

    public boolean isAnonymous() {
        return this.remoteUser() == null;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public ApplicationUser loggedInUser() {
        return ApplicationUsers.from(this.remoteUser);
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public String getFocusId() {
        return this.focusId;
    }
}

