/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.JiraDateUtils;
import java.util.Date;

public class WorklogImpl
implements Worklog {
    private final WorklogManager worklogManager;
    private final Long id;
    private final String authorKey;
    private final String updateAuthorKey;
    private final String comment;
    private final String groupLevel;
    private final Long roleLevelId;
    private final Date created;
    private final Date updated;
    private final Date startDate;
    private final Long timeSpent;
    private final Issue issue;

    public WorklogImpl(WorklogManager worklogManager, Issue issue, Long id, String authorKey, String comment, Date startDate, String groupLevel, Long roleLevelId, Long timeSpent) {
        if (timeSpent == null) {
            throw new IllegalArgumentException("timeSpent must be set!");
        }
        this.worklogManager = worklogManager;
        this.authorKey = authorKey;
        this.updateAuthorKey = authorKey;
        this.comment = comment;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.timeSpent = timeSpent;
        Date createDate = new Date();
        this.startDate = startDate == null ? createDate : startDate;
        this.created = createDate;
        this.updated = createDate;
        this.issue = issue;
        this.id = id;
    }

    public WorklogImpl(WorklogManager worklogManager, Issue issue, Long id, String authorKey, String comment, Date startDate, String groupLevel, Long roleLevelId, Long timeSpent, String updateAuthorKey, Date created, Date updated) {
        if (timeSpent == null) {
            throw new IllegalArgumentException("timeSpent must be set!");
        }
        this.worklogManager = worklogManager;
        this.authorKey = authorKey;
        if (updateAuthorKey == null) {
            updateAuthorKey = this.authorKey;
        }
        this.updateAuthorKey = updateAuthorKey;
        this.comment = comment;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.timeSpent = timeSpent;
        Date createdDate = JiraDateUtils.copyOrCreateDateNullsafe(created);
        this.startDate = startDate == null ? createdDate : startDate;
        this.created = createdDate;
        this.updated = updated == null ? createdDate : updated;
        this.issue = issue;
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getAuthor() {
        return this.authorKey;
    }

    @Override
    public String getAuthorFullName() {
        ApplicationUser user = this.getAuthorObject();
        if (user != null) {
            return user.getDisplayName();
        }
        return this.authorKey;
    }

    @Override
    public String getUpdateAuthor() {
        return this.updateAuthorKey;
    }

    @Override
    public String getUpdateAuthorFullName() {
        ApplicationUser user = this.getUpdateAuthorObject();
        if (user != null) {
            return user.getDisplayName();
        }
        return this.updateAuthorKey;
    }

    @Override
    public String getAuthorKey() {
        return this.authorKey;
    }

    @Override
    public ApplicationUser getAuthorObject() {
        return ApplicationUsers.byKey(this.authorKey);
    }

    @Override
    public String getUpdateAuthorKey() {
        return this.updateAuthorKey;
    }

    @Override
    public ApplicationUser getUpdateAuthorObject() {
        return ApplicationUsers.byKey(this.updateAuthorKey);
    }

    @Override
    public Date getStartDate() {
        return JiraDateUtils.copyDateNullsafe(this.startDate);
    }

    @Override
    public Long getTimeSpent() {
        return this.timeSpent;
    }

    @Override
    public String getGroupLevel() {
        return this.groupLevel;
    }

    @Override
    public Long getRoleLevelId() {
        return this.roleLevelId;
    }

    @Override
    public ProjectRole getRoleLevel() {
        return this.roleLevelId == null ? null : this.worklogManager.getProjectRole(this.roleLevelId);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }
}

